/* wordinfo.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/*
 * $Id: wordinfo.h,v 1.4 92/03/08 18:54:13 lee Exp $
 */

typedef unsigned long t_WID;

#ifndef PBLOCK_H
# include "pblock.h"
#endif

#ifndef WIDBLOCKSIZE
#define WIDBLOCKSIZE 32
#endif

extern char *WidIndexFile; /* Default.c */

/* this is a hack for speed: */
#define GetNextWID SpoofGetNextWID

/** A t_WordInfo describes a single word, in terms of
 ** where it came from
 ** how to find its database entries
 ** how to find the in-core database entries (a copy of the above)
 **/

/* There would be a performance benefit if this struct was smaller.
 * It was foolish of me to use WordInfo for so many different things in
 * addfile, and now I pay the price.
 * Addfile may end up calling malloc for 10,000 of these things...
 *
 * There should be:
 * t_WordPlace (exists, pblock.h)
 *	for recording a specific occurrence of a given word in a given file
 * t_WordInfo (definition follows... look down...)
 *	for recording information about a WID's entry in the database
 * t_pblock (exists, see pblock.h)
 *	for containing the list of WordPlaces found in the database for a
 *	given word, or for putting them there.  Uses arrays rather than
 *	lists to squeeze a few extra milliseconds.  Some hope :-( :-)
 *
 * All of the entries marked with a leading comment (below) should
 * be elsewhere (and some of them were, in the Grand Design!).
 *
 */
typedef struct s_WordInfo {
    char *Word;
    t_WID WID; /* My Word Identifier */
    unsigned long NumberOfWordPlaces; /* total */
    t_FID FID; /* where we got it from */
    unsigned long Offset; /* word entry position in the data base */
    struct s_WordInfo *Next; /* for making lists of WordInfo structs */
    char *DataBlock; /* for writing me out to the index */
    char *WordPlaceStart;
    t_WordPlace *WordPlaces; /* first few pairs */
    t_WordPlace WordPlace; /* For addfile -- this is due to go!!!! */
    /* shorts are at the end to obviate alignment padding... */
    unsigned long WordPlacesInHere;
    unsigned short Length; /* Word length; reduce the need for strlen */
#if 0
    unsigned char Flags;
	/* Flags serve two purposes:
	 * the LSB says whether the entry is sorted.
	 * the remainder are a logical AND of all entries in a sorted
	 * block.  NOTE: if the block is unsorted, the other bits should
	 * still be up to date.
	 */
#endif
} t_WordInfo;

/*
 * $Log:	wordinfo.h,v $
 * Revision 1.4  92/03/08  18:54:13  lee
 * updated comments.
 * 
 * Revision 1.3  90/10/06  02:21:30  lee
 * Prepared for first beta release.
 * 
 * Revision 1.2  90/08/09  19:16:04  lee
 * after BSD lint and saber-C
 * 
 * Revision 2.2  89/10/08  20:47:27  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 * Revision 2.1  89/10/02  01:16:15  lee
 * New index format, with Block/WordInBlock/Flags/BytesSkipped info.
 * 
 * Revision 1.3  89/09/17  23:04:52  lee
 * Various fixes; NumberInBlock now a short...
 * 
 * Revision 1.2  89/09/16  21:15:49  lee
 * First demonstratable version.
 * 
 * Revision 1.1  89/09/07  21:06:16  lee
 * Initial revision
 * 
 */
