#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

main(argc, argv)
    int argc;
    char *argv[];
{
    int s;
    int len;
    struct sockaddr_in sa;
    struct hostent *hp;
    /*
    struct servent *sp;
    */
    char buf[BUFSIZ];
    char *progname;
    char *host;
    char *user;
    int port;

    progname = argv[0];

    if (argc != 4 && argc != 3) {
	(void) fprintf(stderr, "Usage: %s host username [port]\n", progname);
	exit(1);
    }
    host = argv[1];
    user = argv[2];
    port = atoi(argv[3]);

    if ((hp = gethostbyname(host)) == NULL) {
	(void) fprintf(stderr, "%s: lookup for host \"%s\" failed\n",
						progname, host);
	exit(1);
    }

    (void) bzero(&sa, sizeof sa);
    (void) bcopy((char *) hp->h_addr, (char *) &sa.sin_addr, hp->h_length);
    sa.sin_family = hp->h_addrtype;

    /*
    if ((sp = getservbyname("whois", "tcp")) == NULL) {
	fprintf(stderr, "%s: No whois service on host \"%s\"\n",
				progname, host);
	exit(1);
    }

    sa.sin_port = sp->s_port;

    */
    sa.sin_port = port;

    if ((s = socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0) {
	perror("socket");
	exit(1);
    }

    (void) fprintf(stderr, "%s: contacting server at %s, socket %d\n",
			progname, host, s);

    if (connect(s, &sa, sizeof sa) < 0) {
	extern int errno;
	int e = errno;

	(void) fprintf(stderr, "%s: connect failed -- error %d: ", progname, e);
	errno = e;
	perror("");
	exit(1);
    }

    if (write(s, user, strlen(user)) != strlen(user)) {
	(void) fprintf(stderr, "%s: write error\n", progname);
	exit(1);
    }

    while ((len = read(s, buf, BUFSIZ)) > 0) {
	(void) write(0, buf, len);
    }

    (void) close(s);
    exit(0);

}
