#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pwd.h>

#define BACKLOG 5
#define MAXHOSTNAME 128

main(argc, argv)
    int argc;
    char *argv[];
{
    int s, t;
    int i;
    struct sockaddr_in sa;
    struct sockaddr isa;
    struct hostent *hp;
    char *progname;
    struct servent *sp;
    char localhost[MAXHOSTNAME + 1];
    int port;

    progname = argv[0];
    port = atoi(argv[1]);

    (void) bzero((char *)&sa, sizeof sa);
    localhost[0] = '\0'; /* paranoia in case the next call fails: */
    (void) gethostname(localhost, MAXHOSTNAME);
    if ((hp = gethostbyname(localhost)) == NULL) {
	(void) fprintf(stderr, "%s: can't get local host info (%s)\n",
				progname, localhost);
	exit(1);
    }

    sa.sin_port = htons(port);
    sa.sin_family = hp->h_addrtype;

    if ((s = socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0) {
	perror("socket()");
	exit(1);
    }
#if 0
    (void) bcopy((char *) hp->h_addr, (char *) &sa.sin_addr, hp->h_length);

#endif
    if (bind(s, &sa, sizeof sa, 0) < 0) {
	extern int errno;
	int e = errno;
	(void) fprintf(stderr, "%s: bind() failed [%d]: ", progname, e);
	errno = e;
	perror("");
	exit(1);
    }

    if (listen(s, BACKLOG) < 0) {
	perror("listen");
    }

    fprintf(stderr, "%s: listening on %s port %d\n",
				progname, localhost, port);
    for (;;) {
	i = sizeof isa;

	if ((t = accept(s, &isa, &i)) < 0) {
	    perror("accept()");
	    exit(1);
	}
	whois(t);
	close(t);
    }
}

whois(sock)
    int sock;
{
    struct passwd *p;
    char buf[BUFSIZ];
    int i;

    if ((i = read(sock, buf, BUFSIZ)) <= 0) {
	return;
    }

    buf[i] = '\0';
    if ((p = getpwnam(buf)) == NULL) {
	strcpy(buf, "User not found.\n");
    } else {
	sprintf(buf, "%s: %s\n", p->pw_name, p->pw_gecos);
    }
    (void) write(sock, buf, strlen(buf));
    return;
}
