/* GetWID.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* GetWID.c -- get the largest current word number
 * 
 * $Id: GetWID.c,v 1.2 92/04/18 19:21:44 lee Exp $
 */

#include "globals.h" /* defines and declarations for database filenames */
#include "error.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>

#include "fileinfo.h"
#include "wordinfo.h"

/** declarations: **/
/** Unix system calls that need to be declared: **/

/** Unix Library Calls that need to be declared: **/

/** lq-text calls that need to be declared: **/
extern unsigned char *ReadBlock();

/** **/

t_WID
GetMaxWID()
{
    unsigned char *p;
    t_WID Result;

    p = ReadBlock(0L);

    Result = (t_WID) p[9]; /* most significant byte */
    Result <<= 8; Result |= (t_WID) p[10];
    Result <<=8; Result |= (t_WID) p[11];
    Result <<=8; Result |= (t_WID) p[12];

    return Result;
}

