/* SetWID.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* SetWID.c -- get/set the largest current word number
 * 
 * $Id: SetWID.c,v 1.3 92/04/18 19:23:01 lee Exp $
 */

#include "globals.h" /* defines and declarations for database filenames */
#include "error.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>

#include "fileinfo.h"
#include "wordinfo.h"

/** declarations: **/
/** Unix system calls that need to be declared: **/

/** Unix Library Calls that need to be declared: **/

/** lq-text calls that need to be declared: **/
extern unsigned char *ReadBlock();
extern void WriteBlock(), FlushCache();
extern t_WID GetMaxWID();

/** **/

extern t_WID LastNextWIDVal;

#undef GetNextWID

t_WID GetNextWID();

INLINE
t_WID
SpoofGetNextWID()
{
    static int SinceLastUpdate = 0;
    t_WID Value;

    /* Call the real function sometimes, so that the database does
     * get updated in case of a crash or for other users.
     */
    if (++SinceLastUpdate > 10000) {
	SinceLastUpdate = 0;
	Value = GetNextWID(1);
    }

    if (LastNextWIDVal == (t_WID) 0) {
	LastNextWIDVal = GetMaxWID();
	SinceLastUpdate = 0;
    }
    return ++LastNextWIDVal;
}

void
WriteCurrentMaxWID()
{
    (void) GetNextWID(1);
    FlushCache(0);
}

t_WID
GetNextWID(WriteCurrent)
    int WriteCurrent; /* simply write the current MaxWID if true */
{
    t_WID Result;
    unsigned char *p;

    /** Alter the file, so other programs can see the new words...
     **/

    p = ReadBlock(0L);

    Result = (t_WID) p[9]; /* most significant byte */
    Result <<= 8; Result |= (t_WID) p[10];
    Result <<=8; Result |= (t_WID) p[11];
    Result <<=8; Result |= (t_WID) p[12];

    /* if WriteCurrent is set, we should not increment anything */
    if (!WriteCurrent) {
	++LastNextWIDVal;
	++Result;
    }

    if (Result < LastNextWIDVal) {
	Result = LastNextWIDVal;
    } else {
	LastNextWIDVal = Result;
    }

    p[12] = (Result & 0xff); /* least significant byte */
    Result >>= 8; p[11] = (Result & 0xff);
    Result >>= 8; p[10] = (Result & 0xff);
    Result >>= 8; p[ 9] = (Result & 0xff);

    WriteBlock(0L, p);
    if (WriteCurrent) {
	FlushCache(0); /* write out entire block cache */
    }

    return Result;
}

