/* 
 * $Id: Unpack.c,v 1.4 92/02/15 06:41:38 lee Exp $
 *
 * Uncompress or dearchive a file and return a an open file descriptor to a 
 * copy of the file in /tmp
 *
 * If a filename contains a ':' it is assumed to be of the form 
 * archive-path:component
 *
 * Only unix compress is currently supported for compressed files
 * Compression is determined via magic number
 *
 * Original by David Bremner (bremner@cs.sfu.ca).
 * Id: UnpackAndOpen.c,v 1.1 1991/06/05 18:39:47 bremner Exp 
 *
 * $Log:	Unpack.c,v $
 * Revision 1.4  92/02/15  06:41:38  lee
 * declared DoCommand.
 * 
 * Revision 1.3  92/02/15  05:08:38  lee
 * name changes; deletedspurious error messages.
 * 
 * Revision 1.2  92/01/29  18:40:39  lee
 * Massive rewriting to get it in the same style as the rest of lq-text.
 * Bug fixes.
 * Added ar support.
 * 
 * Revision 1.1  92/01/29  18:20:38  lee
 * Initial revision
 * 
 *
 */

#include "globals.h"

#include <sys/types.h>
#include <unistd.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#define index strchr
#endif
/** #include <sys/uio.h> I don't know why David Bremner included this **/
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include "emalloc.h"
#include "fileinfo.h"

extern int AsciiTrace;

/* From Kyle Jones crypt.el */

#define COMPRESS_MAGIC  "\037\235\220"
#define COMPRESS_LEN (sizeof(COMPRESS_MAGIC) - 1)
#define UNCOMPRESS_COMMAND "compress -d < %s > %s"
#define AR_COMMAND "ar p '%s' '%s' > %s"
/* Archives are accessed as archivename(component), where the ( and )
 * characters are START_CHAR and END_CHAR respectively.  Define END_CHAR to
 * be \0 to disable it.
 */
#define START_CHAR '('
#define END_CHAR ')'

static int DoCommand();

int
UnpackAndOpen(FileName)
    char *FileName;
{
    int fd;
    char magic_buffer[4];
    char *Component;
  
    if ((fd = open(FileName, O_RDONLY, 0)) < 0) {
	/* Check to see if it could be a name of the form
	 * archivename(component);
	 * Archive Component
	 */
	if ((Component = index(FileName, START_CHAR)) != (char *) 0) {
	    char *ArchiveName = emalloc(Component - FileName + 1);
	    char *ArchiveLocation = 0; /* search filepath */
	    char *p;
	    int Newfd;

	    if (!ArchiveName) return -1;
	    if (END_CHAR && FileName[strlen(FileName) - 1] != END_CHAR) {
		(void) efree(ArchiveName);
		return -1;
	    }

	    (void) strncpy(ArchiveName, FileName, Component - FileName);
	    ArchiveName[Component - FileName] = '\0';
	    ArchiveLocation = FindFile(ArchiveName);

	    if (!ArchiveLocation) {
		(void) efree(ArchiveName);
		return -1;
	    }
	    ++Component; /* skip over FIRST_CHAR */
	    if (END_CHAR) {
		char *q;
		p = emalloc(strlen(Component) + 1);
		(void) strcpy(p, Component);
		q = rindex(p, END_CHAR);
		if (q && q[1] == '\0') {
		    *q = '\0';
		}
	    } else {
		p = emalloc(strlen(Component) + 1);
		(void) strncpy(p, Component, strlen(Component));
	    }
	    Component = p;
#ifdef ASCIITRACE
	    if (AsciiTrace > 4) {
		fprintf(stderr, "%s; archive %s; Component %s\n",
		    progname, ArchiveLocation, Component);
	    }
#endif
	    
	    (void) close(fd);
	    Newfd = UnpackArchive(ArchiveLocation, Component);
	    (void) efree(ArchiveName);
	    (void) efree(Component);
	    return Newfd;
	}
	return -1;
    }

    if (read(fd, magic_buffer, COMPRESS_LEN) == COMPRESS_LEN) {

	if (strncmp(magic_buffer, COMPRESS_MAGIC, COMPRESS_LEN) == 0) {
	    (void) close(fd);
	    return DoCommand(UNCOMPRESS_COMMAND, FileName);
	}
    }


    /* If we fall thorough to here, it is just a regular file */

    /* reset file pointer */
    if (lseek(fd,0L,SEEK_SET) < 0 ) {
	(void) close(fd);
	return -1;
    } else {
	return fd;
    }
/*NOTREACHED*/
}

int
UnpackArchive(ArchiveLocation, Component)
    char *ArchiveLocation; /* a full pathname */
    char *Component;
{
    int fd;
    char *Tmp = emalloc(strlen(ArchiveLocation) + strlen(AR_COMMAND));

    (void) sprintf(Tmp, AR_COMMAND, ArchiveLocation, "%s", "%s");
    fd = DoCommand(Tmp, Component);
    (void) efree(Tmp);
    return fd;
}

static int
DoCommand(Command, InputFile)
    char *Command;
    char *InputFile;
{
    char template[30];
    char *Buffer;
    int fd;

    /* ucompress the file in /tmp... */
    (void) strcpy(template, "/tmp/lq-textXXXXXX");
    mktemp(template);

    Buffer = emalloc(strlen(Command) + strlen(InputFile) + strlen(template));

    sprintf(Buffer, Command, InputFile, template);
#ifdef ASCIITRACE
    if (AsciiTrace > 4) {
	fprintf(stderr, "%s: cmd: %s\n", progname, Buffer);
	(void) fflush(stderr);
    }
#endif
    system(Buffer);
    (void) free(Buffer);

    fd = UnpackAndOpen(template);
    (void) unlink(template); 
    return fd;
}
