:
# matchword pattern [...] -- grep for words in the database
#
# matchword -- Copyright 1990 Liam R. Quin.  All Rights Reserved.
# This code is NOT in the public domain.
# See the file ../COPYRIGHT for full details.
#
# $Id: matchword.sh,v 1.2 90/10/06 00:51:02 lee Rel1-10 $
#

# "echo" portability test:
N=; C='\c'; if [ x"`echo -n hello`" = x"hello" ]; then N=-n;C=; fi
export N C

ans=no
while [ x"$ans" != x"q" ]
do
    echo $N "Enter a word or pattern: $C"
    read pattern
    if [ x"$pattern" = x"q" ]
    then
	break
    fi
    WORDS=`lqword | grep "^${pattern}\$"`
    if [ "$WORDS" = "" ]
    then echo "(no match in the database for ${pattern})"
    else echo `echo "$WORDS" | wc -l` words found:
	 echo "$WORDS" | sort -d | rs | ${PAGER-more}
	 # If you don't have rs, you could use cat instead.
	 # PAGER could also be "pg -nse", or "less -q".
    fi
done

