NAME
====
Async::Command

AUTHOR
======
Mark Devine <mark@markdevine.com>

VERSION
=======
0.0.1

TITLE
=====
Asynchronous Command

SUBTITLE
========
Wrap an external command in a promise & capture results.

Description
===========
Async::Command is a module that will run the specified
command in a promise, enforce a timeout, capture $*ERR
& $*OUT, and record the exit status. All of this is
contained in an Async::Command::Result object for
examination afterward.

Examples
========
An example script that runs a curl command
------------------------------------------

    use Async::Command;

    my @command = [
                    'curl',
                    '-H', 'Content-Type:application/json',
                    '-d', '{"user":"myuserid","password":"mYpAsSwOrD!"}',
                    '-X', ' POST',
                    '-k',
                    '-s',
                    'https://10.20.30.40/api/get_token',
                 ];

    dd $ = Async::Command.new(:@command, :2timeout).run;

Returns an Async::Command::Result object
----------------------------------------

    Async::Command::Result $ =
        Async::Command::Result.new(
            command => [
                "curl",
                "-H", "Content-Type:application/json",
                "-d", "\{\"user\":\"myuserid\",\"password\":\"mYpAsSwOrD\"}",
                "-X", " POST",
                "-k",
                "-s",
                "https://10.20.30.40/api/get_token"
            ],
            exitcode => 0,
            stdout-results => "\{\"token\":\"123456789123456789123456789123456789\"}",
            stderr-results => "",
            timed-out => Bool::False,
            unique-id => Str
        )

See Async::Command::Result for accessors.

See Also
========
Async::Command::Multi
