/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;

class CipherBlockChaining
extends SymmetricCipher
implements FeedbackCipher {
    private static final String MODE_NAME = "CBC";
    private byte[] iv = null;
    private byte[] r;
    private byte[] k;
    private SymmetricCipher embeddedCipher;
    private int blockSize = -1;

    CipherBlockChaining() {
    }

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        byte[] byArray3 = null;
        int n4 = n + n2;
        if (byArray == byArray2 && n >= n3 && n - n3 < this.blockSize) {
            byArray3 = (byte[])byArray.clone();
        }
        while (n < n4) {
            this.embeddedCipher.decrypt(byArray, n, this.blockSize, this.k, 0);
            int n5 = 0;
            while (n5 < this.blockSize) {
                byArray2[n5 + n3] = (byte)(this.k[n5] ^ this.r[n5]);
                ++n5;
            }
            if (byArray3 == null) {
                System.arraycopy(byArray, n, this.r, 0, this.blockSize);
            } else {
                System.arraycopy(byArray3, n, this.r, 0, this.blockSize);
            }
            n += this.blockSize;
            n3 += this.blockSize;
        }
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        int n4 = n + n2;
        while (n < n4) {
            int n5 = 0;
            while (n5 < this.blockSize) {
                this.k[n5] = (byte)(byArray[n5 + n] ^ this.r[n5]);
                ++n5;
            }
            this.embeddedCipher.encrypt(this.k, 0, this.blockSize, byArray2, n3);
            System.arraycopy(byArray2, n3, this.r, 0, this.blockSize);
            n += this.blockSize;
            n3 += this.blockSize;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getFeedback() {
        return MODE_NAME;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void init(Key key) throws InvalidKeyException {
        this.embeddedCipher.init(key);
        SecureRandom secureRandom = new SecureRandom();
        this.iv = new byte[this.blockSize];
        secureRandom.nextBytes(this.iv);
        System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
    }

    public void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.embeddedCipher.init(key);
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.iv = ivParameterSpec.getIV();
            if (this.iv == null || this.iv.length != 8) {
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 bytes long");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
        }
        System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
    }

    public void reset() {
        System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
    }

    public void setEmbeddedCipher(SymmetricCipher symmetricCipher) throws NoSuchAlgorithmException {
        if (symmetricCipher == null || (this.blockSize = symmetricCipher.getBlockSize()) <= 0) {
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = symmetricCipher;
        this.k = new byte[this.blockSize];
        this.r = new byte[this.blockSize];
    }
}

