/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.BigInt;
import com.sun.crypto.provider.DerOutputStream;
import com.sun.crypto.provider.DerValue;
import com.sun.crypto.provider.HexDumpEncoder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEParameters
extends AlgorithmParametersSpi {
    private byte[] salt;
    private int iCount;

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.salt);
        derOutputStream2.putInteger(new BigInt(BigInteger.valueOf(this.iCount)));
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName("javax.crypto.spec.PBEParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return new PBEParameterSpec(this.salt, this.iCount);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBEParameterSpec)algorithmParameterSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("PBE parameter parsing error: not a sequence");
            }
            derValue.data.reset();
            this.salt = derValue.data.getOctetString();
            this.iCount = derValue.data.getInteger().toInt();
            if (derValue.data.available() != 0) {
                throw new IOException("PBE parameter parsing error: extra data");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("iteration count too big");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        String string = "\n    salt:\n[";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = String.valueOf(string) + hexDumpEncoder.encodeBuffer(this.salt);
        string = String.valueOf(string) + "]";
        return String.valueOf(string) + "\n    iterationCount:\n" + new BigInt(BigInteger.valueOf(this.iCount)).toString() + "\n";
    }
}

