.\" 
.\"
.ds h ""KerbNet -- Kerberos V5" "Cygnus Solutions""
.TH ASETKEY 8 \*h
.UC 4
.SH NAME
asetkey \- register keys from Kerberos V5 for AFS server use 

.SH SYNOPSIS
.B asetkey add
kvno keyfile princ

.B asetkey delete
kvno

.B asetkey list

.SH DESCRIPTION
The
.I asetkey
program is used to register keys with 
.I AFS,
servers via the 
.IR afsconf_AddKey
function. This version takes an entry from a Kerberos V5 
.I v5srvtab
file, extracts the key, and registers it with the server.

.SH EXIT CODES
The exit status of
.I asetkey
will be one of the following:
.TP 5
0
Success -- No error occurred.
.TP 5
1
Failure -- some error occured, and diagnostics were printed.

.SH EXAMPLES
.br
To set up a server for V5 use:
.sp
.in +.5in
.nf
% kadmin
kadmin: add_principal afs/cell.name
kadmin: ktadd -k cell.name-new-keytab afs/cell.name
.fi
.in -.5in
.sp
This should create a cell.name-new-keytab which should be securely moved
to the afs server and placed in /etc/v5srvtab.
.PP
To double check, 
.sp
.in +.5in
% klist -k cell.name-new-keytab
.in -.5in
.PP
Then, running
.sp
.in +.5in
% asetkey add 2 /etc/v5srvtab afs/cell.name 
.in -.5in
.sp
will initialize the afs key list.  In this example, 2 is the key version
number displayed by
.I klist,
and
.I afs/cell.name
is the principal for the server (which will get converted by krb524d to
afs.cell.name.)
.sp
.in +.5in
% asetkey list
.in -.5in
.sp
will show the current set of keys.

.SH SEE ALSO
kinit(1), kadmin(8), afsconf_AddKey(3)

.SH AUTHOR
Richard Basch (MIT-Project Athena)

V5 support and man page by Mark Eichin (Cygnus Support)
