/* $XConsortium: krb5auth.c,v 1.4 94/04/17 20:03:40 gildea Exp $ */
/*

Copyright (c) 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/*
 * xdm - display manager daemon
 * Author:  Stephen Gildea, X Consortium
 */

/*
 * krb5auth
 *
 * generate Kerberos Version 5 authorization records
 */

#include "defines.h"
#include "dm.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <krb5.h>

krb5_context     context;
int Krb5InitDone = -1;

/*ARGSUSED*/
Krb5InitAuth (name_len, name)
    unsigned short  name_len;
    char	    *name;
{
    krb5_init_context(&context); /* initialize krb5 context */
    krb5_init_ets(context);	 /* initialize error_message() tables */
}

/*
 * Returns malloc'ed string that is the credentials cache name.
 * name should be freed by caller.
 */
char *
Krb5CCacheName(dname)
    char *dname;
{
    char *name;
    char *tmpdir;

    tmpdir = getenv("TMPDIR");
    if (!tmpdir)
	tmpdir = "/tmp";
    name = malloc(strlen(tmpdir) + strlen(dname) + 20);
    if (!name)
	return NULL;
    sprintf(name, "FILE:%s/K5C", tmpdir);
    CleanUpFileName(dname, name+strlen(name), strlen(dname)+1);
    return name;
}

krb5_error_code
Krb5DisplayCCache(dname, ccache_return, context_return)
    char *dname;
    krb5_ccache *ccache_return;
    krb5_context *context_return;
{
    krb5_error_code code;
    char            *name;

    name = Krb5CCacheName(dname);
    Debug("resolving Kerberos cache %s\n", name);
    code = krb5_cc_resolve(context, name, ccache_return);
    *context_return = context;
    return code;
}

Xauth *
Krb5GetAuthFor(namelen, name, dname)
    unsigned short namelen;
    char *name;
    char *dname;
{
    Xauth   *new;
    char *filename;
    struct stat statbuf;

    new = (Xauth *) malloc (sizeof *new);
    if (!new)
	return (Xauth *) 0;
    new->family = FamilyWild;
    new->address_length = 0;
    new->address = 0;
    new->number_length = 0;
    new->number = 0;

    if (dname)
    {
	filename = Krb5CCacheName(dname);
	new->data = (char *) malloc (3 + strlen(filename) + 1);
	if (!new->data)
	{
	    free (filename);
	    free ((char *) new);
	    return (Xauth *) 0;
	}
	strcpy(new->data, "UU:");
	strcat(new->data, filename);
	free (filename);
	new->data_length = strlen(new->data);
    }
    else
    {
	new->data = NULL;
	new->data_length = 0;
    }

    new->name = (char *) malloc (namelen);
    if (!new->name)
    {
	free ((char *) new->data);
	free ((char *) new);
	return (Xauth *) 0;
    }
    memmove( new->name, name, namelen);
    new->name_length = namelen;
    return new;
}


Xauth *
Krb5GetAuth (namelen, name)
    unsigned short  namelen;
    char	    *name;
{
    return Krb5GetAuthFor(namelen, name, NULL);
}

krb5_preauthtype preauth_search_list[] = {
	0,			
	KRB5_PADATA_ENC_TIMESTAMP,
	-1
	};

/*
 * Krb5Init - lifted from kinit.c
 * Get TGT.
 * Returns 0 if successful, 1 if not.
 */
int
Krb5Init(name, passwd, d)
    char *name;
    char *passwd;
    struct display *d;		/* k5_ccache filled in if successful */
{
    krb5_ccache ccache;
    krb5_error_code code;
    krb5_principal me;
    krb5_creds my_creds;
    krb5_principal server;
    krb5_address **my_addresses;
    krb5_timestamp now;
    krb5_context   context;
    int	i;
    char *cachename;
    krb5_data tgtname;

    if (passwd[0] == 0) {
	LogError ("empty password not permitted by Kerberos");
	return 1;
    }

    tgtname.length = KRB5_TGS_NAME_SIZE;
    tgtname.data = KRB5_TGS_NAME;

    krb5_init_context(&context);
    krb5_init_ets(context);

    cachename = Krb5CCacheName (d->name);
    if (code = krb5_cc_resolve (context, cachename, &ccache))
    {
         LogError("%s while obtaining Krb5 cache \"%s\"\n",
		  error_message(code), cachename);
         return 1;
    }

    if (code = krb5_parse_name (context, name, &me)) {
	 LogError("%s while parsing Krb5 name \"%s\"\n",
		  error_message(code), name);
	 return 1;
    }

    code = krb5_cc_initialize (context, ccache, me);
    if (code != 0) {
	LogError("%s while initializing Krb5 cache \"%s\"\n",
		 error_message(code), cachename);
	return 1;
    }

    memset((char *)&my_creds, 0, sizeof(my_creds));

    my_creds.client = me;

    if (code = krb5_build_principal_ext(context,
                                        &server,
					krb5_princ_realm(context, me)->length,
					krb5_princ_realm(context, me)->data,
					tgtname.length, tgtname.data,
					krb5_princ_realm(context, me)->length,
					krb5_princ_realm(context, me)->data,
					0)) {
	LogError("%s while building Krb5 TGT server name\n",
		 error_message(code));
	return 1;
    }

    my_creds.server = server;

    code = krb5_os_localaddr(context, &my_addresses);
    if (code != 0) {
	LogError("%s while getting my address for Krb5\n",
		 error_message(code));
	return 1;
    }
    if (code = krb5_timeofday(context, &now)) {
	LogError("%s while getting time of day for Krb5\n",
		 error_message(code));
	return 1;
    }
    my_creds.times.starttime = 0;	/* start timer when request
					   gets to KDC */
    my_creds.times.endtime = now + KRB5_DEFAULT_LIFE ; /* 8 hours */
    my_creds.times.renew_till = 0;

    for (i = 0; /*preauth_search_list[i] >= 0*/ i == 0; i++) {
	code = krb5_get_in_tkt_with_password(context,
                                             KDC_OPT_FORWARDABLE, 
                                             my_addresses,
					     NULL /* &enctype */,
					     NULL /* &preauth_search_list[i] */,
					     passwd,
					     ccache,
					     &my_creds, 
                                             0);
	if (/* code != KRB5KDC_PREAUTH_FAILED && */
	    code != KRB5KRB_ERR_GENERIC)
	    break;
    }

    krb5_free_principal(context, server);
    krb5_free_addresses(context, my_addresses);

    if (code) {
	char *my_name = NULL;
	int code2 = krb5_unparse_name(context, me, &my_name);
	if (code == KRB5KRB_AP_ERR_BAD_INTEGRITY) {
	    LogError ("password incorrect for Krb5 principal \"%s\"\n",
		      code2 ? name : my_name);
	}
	else
	    LogError("%s while getting initial Krb5 credentials for \"%s\"\n",
		     error_message(code), code2 ? name : my_name);
	if (my_name)
	    free (my_name);
	return 1;
    }
    krb5_cc_close(context, ccache);
    return 0;
}

/*
 * Krb5Version
 * Print the version and exit
 */
int
Krb5Version()
{
    printf("%s\n", krb5_version);
    exit(0);
}
