/*
 * type functions split out of here to make things look nicer in the
 * various include files which need these definitions, as well as in
 * the util/ directories.
 */

#ifndef _KRB5_WIN_MAC_H
#define _KRB5_WIN_MAC_H

#if (defined(_MSDOS) || (defined(_WIN32) && !defined(__CYGWIN32__)))
/* 
 * Machine-type definitions: PC Clone 386 running Microloss Windows
 */

#if defined(_MSDOS)
	/* Windows 16 specific */
#define BITS16
#define SIZEOF_INT      2
#define SIZEOF_SHORT    2
#define SIZEOF_LONG     4

#ifndef KRB5_CALLCONV
#define KRB5_CALLCONV __far __export __pascal
#define KRB5_CALLCONV_C __far __export __cdecl
#define KRB5_DLLIMP
#endif /* !KRB5_CALLCONV */

/*
 * The following defines are needed to make <windows.h> work
 * in stdc mode (/Za flag). Winsock.h needs <windows.h>.
 */
#define FAR     __far
#define NEAR    __near
#define _far    __far
#define _near   __near
#define _pascal __pascal
#define _cdecl  __cdecl
#define _huge   __huge

#ifdef NEED_WINDOWS
#include <windows.h>
#endif
	
#else
	/* Windows 32 specific */
#define SIZEOF_INT      4
#define SIZEOF_SHORT    2
#define SIZEOF_LONG     4

#include <windows.h>   /* always include this here, to get correct FAR and NEAR */

#ifndef KRB5_CALLCONV
#ifdef KRB5_DLL_FILE
#define KRB5_DECLSPEC dllexport
#else
#define KRB5_DECLSPEC dllimport
#endif
#define KRB5_DLLIMP __declspec(KRB5_DECLSPEC)
#define KRB5_CALLCONV __stdcall
#define KRB5_CALLCONV_C __cdecl
#endif /* !KRB5_CALLCONV */

#endif /* _MSDOS */

#define KRB5_PROVIDE_PROTOTYPES
#define HAS_VOID_TYPE
#define HAVE_STDARG_H
#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif /* !_SIZE_T_DEFINED */
#ifndef KRB5_SYSTYPES__
#define KRB5_SYSTYPES__
#include <sys/types.h>
typedef unsigned long	u_long;      /* Not part of sys/types.h on the pc */
typedef unsigned int	u_int;
typedef unsigned short	u_short;
typedef unsigned char	u_char;
#endif /* KRB5_SYSTYPES__ */

#define MAXHOSTNAMELEN  512
#define MAXPATHLEN      256            /* Also for Windows temp files */

#define KRB5_USE_INET
#define MSDOS_FILESYSTEM
#define USE_STRING_H 
#define HAVE_SRAND
#define HAVE_ERRNO
#define HAS_STRDUP
#ifdef _WIN32
#define HAS_LABS
#endif
#define NO_USERID
#define NOFCHMOD
#define NOCHMOD
#define NO_PASSWORD
#define WM_KERBEROS5_CHANGED "Kerberos5 Changed"

#define HAS_ANSI_VOLATILE
#define HAS_VOID_TYPE
#define KRB5_PROVIDE_PROTOTYPES
#define HAVE_STDARG_H
#define HAVE_SYS_TYPES_H
#define HAS_STDLIB_H

/* This controls which encryption routines libcrypto will provide */
#define PROVIDE_DES_CBC_MD5
#define PROVIDE_DES_CBC_CRC
#define PROVIDE_DES_CBC_RAW
#define PROVIDE_DES_CBC_CKSUM
#define PROVIDE_CRC32
#define PROVIDE_RSA_MD4
#define PROVIDE_RSA_MD5

#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif 

/* Ugly. Microsoft, in stdc mode, doesn't support the low-level i/o
 * routines directly. Rather, they only export the _<function> version.
 * The following defines works around this problem. 
 */
#include <sys\types.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <io.h>
#include <process.h>
#define THREEPARAMOPEN(x,y,z) open(x,y,z)
#ifndef _WIN32
#define O_RDONLY        _O_RDONLY
#define O_WRONLY        _O_WRONLY
#define O_RDWR          _O_RDWR
#define O_APPEND        _O_APPEND
#define O_CREAT         _O_CREAT
#define O_TRUNC         _O_TRUNC
#define O_EXCL          _O_EXCL
#define O_TEXT          _O_TEXT
#define O_BINARY        _O_BINARY
#define O_NOINHERIT     _O_NOINHERIT
#define stat            _stat
#define unlink          _unlink
#define lseek           _lseek
#define write           _write
#define open            _open
#define close           _close
#define read            _read
#define fstat           _fstat
#define mktemp          _mktemp
#define dup             _dup

#define getpid          _getpid
#endif

#ifdef NEED_SYSERROR
/* Only needed by util/et/error_message.c but let's keep the source clean */
#define sys_nerr        _sys_nerr
#define sys_errlist     _sys_errlist
#endif

/*
 * Functions with slightly different names on the PC
 */
#define strcasecmp   stricmp
#define strncasecmp  strnicmp
#if 0
#define strdup       _strdup
#define off_t        _off_t
#endif

#endif /* _MSDOS || _WIN32 */

#ifndef KRB5_CALLCONV
#define KRB5_CALLCONV
#define KRB5_CALLCONV_C
#define KRB5_DLLIMP
#endif
#ifndef FAR
#define FAR
#endif
#ifndef NEAR
#define NEAR
#endif

/* Mac stuff starts here */
#ifdef _MACINTOSH
#define SIZEOF_INT 4
#define SIZEOF_SHORT 2
#define MAXPATHLEN 255

#define ANSI_STDIO
#define HAVE_STRFTIME 1
#define HAVE_SYSLOG_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STDARG_H 1
#define NO_SYS_TYPES_H
#define NO_SYS_STAT_H

#define HAVE_SRAND
#define HAS_LABS
#define NOCHMOD 1
#define NOFCHMOD 1

#define NO_PASSWORD

#ifndef _SIZET
typedef unsigned int size_t;
#define _SIZET
#endif
#include <unix.h>
#include <ctype.h>

#ifdef NEED_LOWLEVEL_IO
#include <fcntl.h>
#endif

#define PROVIDE_RSA_MD4
#define PROVIDE_RSA_MD5
#define PROVIDE_CRC32
#define PROVIDE_DES_CBC_CKSUM
#define PROVIDE_DES_CBC_CRC
#define PROVIDE_DES_CBC_MD5
#define PROVIDE_DES_CBC_RAW
#define PROVIDE_DES3_CBC_MD5
#define PROVIDE_DES3_CBC_RAW


/* there is no <stat.h> for mpw */
#ifndef __MWERKS__
typedef unsigned long	mode_t;
typedef unsigned long	ino_t;
typedef unsigned long	dev_t;
typedef short			nlink_t;
typedef unsigned long	uid_t;
typedef unsigned long	gid_t;
typedef long			off_t;

struct stat
{
	mode_t		st_mode;	/* File mode; see #define's below */
	ino_t		st_ino;		/* File serial number */
	dev_t		st_dev;		/* ID of device containing this file */
	nlink_t		st_nlink;	/* Number of links */
	uid_t		st_uid;		/* User ID of the file's owner */
	gid_t		st_gid;		/* Group ID of the file's group */
	dev_t		st_rdev;	/* Device type */
	off_t		st_size;	/* File size in bytes */
	unsigned long	st_atime;	/* Time of last access */
	unsigned long	st_mtime;	/* Time of last data modification */
	unsigned long	st_ctime;	/* Time of last file status change */
	long		st_blksize;	/* Optimal blocksize */
	long		st_blocks;	/* blocks allocated for file */
};

int stat(const char *path, struct stat *buf);
int fstat(int fildes, struct stat *buf);
#else
#include <stat.h>
#endif

/*
 * Rename various socket type operations to avoid cluttering the namespace
 */
#define socket			krb5_socket
#define closesocket		krb5_closesocket
#define connect			krb5_connect
#define bind			krb5_bind
#define send			krb5_send
#define recv			krb5_recv
#define sendto			krb5_sendto
#define select			krb5_select
#define recvfrom		krb5_recvfrom
#define inet_ntoa		krb5_inet_ntoa
#define gethostbyname	krb5_gethostbyname
#define gethostbyaddr	krb5_gethostbyaddr
#define gethostname		krb5_gethostname
#define getsockname		krb5_getsockname
#define getmyipaddr		krb5_getmyipaddr

#define OpenOurRF 		krb5_OpenOurRF
#define OpenResolver	krb5_OpenResolver
#define CloseResolver	krb5_CloseResolver
#define StrToAddr		krb5_StrToAddr
#define AddrToStr		krb5_AddrToStr
#define EnumCache		krb5_EnumCache
#define AddrToName		krb5_AddrToName
#define dnr				krb5_dnr
#define codeHndl		krb5_codeHndl

#define _MACSOCKAPI_

typedef int datum;

//jfm need to reimplement
#define mktemp(a)

#define ENOENT 500
#define EPERM 501
#define EACCES 502
#define EISDIR 503
#define ENOTDIR 504
#define ELOOP 505
#define ETXTBSY 506
#define EBUSY 507
#define EROFS 508
#define EINVAL 509
#define EEXIST 510
#define EFAULT 511
#define EBADF 512
#define ENAMETOOLONG 513
#define EWOULDBLOCK 514
#define EDQUOT 515
#define ENOSPC 516
#define EIO 517
#define ENFILE 518
#define EMFILE 519
#define ENXIO 520
#define ECONNABORTED 521
#define ENOMEM 522
#define EFBIG 523

#define THREEPARAMOPEN(x,y,z) open(x,y)
#else /* _MACINTOSH */
#define THREEPARAMOPEN(x,y,z) open(x,y,z)
#endif /* _MACINTOSH */

#endif /* _KRB5_WIN_MAC_H */
