# For debugging only.  I really wish the command loop were written in
# tcl rather than coded directly in C, buried in tclMain.c where I can't
# get at it from tcl code...
proc interactive { } {
    set partial ""
    while 1 {
	# use tcl_prompt2 if incomplete command pending
	if [string length $partial] {
	    set varname tcl_prompt2
	    set dflprompt "> "
	} else {
	    set varname tcl_prompt1
	    set dflprompt "% "
	}
	if [info exists $varname] {
	    eval [set $varname]
	} else {
	    puts -nonewline $dflprompt
	}
	flush stdout
	if [gets stdin cmd]==-1 { return }
	# check for incomplete command...
	set cmd "$partial$cmd"
	if ![info complete $cmd] {
	    set partial "$cmd\n"
	    continue
	}
	set partial ""
	set success 0
	set err ""
	set result ""
	catch {set result [uplevel $cmd] ; set success 1 ; return} err
	if [string compare "" $err] { puts $err } \
		elseif [string compare "" $result] { puts $result }
    }
}

# Print the current profile data to the terminal.
proc prof {} {
    global profile
    krb5tcl_write_profile /dev/tty $profile
}
