/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "krb5.h"
#include <krb.h>
#include "krb524.h"

/*
 * krb524_convert_tkt.  Open a network connection to krb524d, send it
 * the V5 ticket, receive the V4 ticket in response.
 */
int krb524_convert_tkt(server, v5tkt, v4tkt, kvno, saddr)
     krb5_principal server;
     krb5_data *v5tkt;
     KTEXT_ST *v4tkt;
     int *kvno;
     struct sockaddr_in *saddr;
{
     char *p;
     krb5_data reply;
     struct servent *serv;
     int ret, status;

     reply.data = NULL;

     if (saddr->sin_port == 0) {
	  serv = getservbyname(KRB524_SERVICE, "udp");
	  if (serv)
	       saddr->sin_port = serv->s_port;
	  else
	       saddr->sin_port = htons(KRB524_PORT);
     }

     if ((ret = krb524_send_message((struct sockaddr *) saddr, v5tkt, &reply)))
	  goto fail;
     
     p = reply.data;
     status = ntohl(*((krb5_error_code *) p));
     p += sizeof(krb5_error_code);
     reply.length -= sizeof(krb5_error_code);
     if (status) {
	  ret = status;
	  goto fail;
     }
     *kvno = ntohl(*((krb5_error_code *) p));
     p += sizeof(int);
     reply.length -= sizeof(int);
     ret = decode_v4tkt(v4tkt, p, &reply.length);

fail:
     if (ret) {
	  if (reply.data) 
	       free(reply.data);
	  reply.data = NULL;
	  reply.length = 0;
     }

     return ret;
}

