/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "krb5.h"
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <signal.h>
#include <netinet/in.h>

#include <krb.h>
#include "krb524.h"

/*
 * I'm sure that this is reinventing the wheel, but I don't know where
 * the wheel is hidden.
 */

int  encode_v4tkt PROTOTYPE((KTEXT_ST *, char *, int *)),
     encode_ktext PROTOTYPE((char **, int *, KTEXT_ST *)),
     encode_bytes PROTOTYPE((char **, int *, char *, int)),
     encode_int32 PROTOTYPE((char **, int *, krb5_int32 *));

int  decode_v4tkt PROTOTYPE((KTEXT_ST *, char *, int *)),
     decode_ktext PROTOTYPE((char **, int *, KTEXT_ST *)),
     decode_bytes PROTOTYPE((char **, int *, char *, int)),
     decode_int32 PROTOTYPE((char **, int *, krb5_int32 *));

int encode_bytes(out, outlen, in, len)
     char **out;
     int *outlen;
     char *in;
     int len;
{
     if (len > *outlen)
	  return KRB524_ENCFULL;
     memcpy(*out, in, len);
     *out += len;
     *outlen -= len;
     return 0;
}

int encode_int32(out, outlen, v)
     char **out;
     int *outlen;
     krb5_int32 *v;
{
     int nv;

     nv = htonl(*v);
     return encode_bytes(out, outlen, (char *) &nv, sizeof(nv));
}

int encode_v4tkt(v4tkt, buf, encoded_len)
     KTEXT_ST *v4tkt;
     char *buf;
     int *encoded_len;
{
     int buflen, ret;

     buflen = *encoded_len;

     if ((ret = encode_int32(&buf, &buflen, &v4tkt->length)))
	  return ret;
     if ((ret = encode_bytes(&buf, &buflen, (char *)v4tkt->dat, MAX_KTXT_LEN)))
	  return ret;
     if ((ret = encode_int32(&buf, &buflen, (krb5_int32 *) &v4tkt->mbz)))
	  return ret;

     *encoded_len -= buflen;
     return 0;
}

/* decode functions */

int decode_bytes(out, outlen, in, len)
     char **out;
     int *outlen;
     char *in; 
     int len;
{
     if (len > *outlen)
	  return KRB524_DECEMPTY;
     memcpy(in, *out, len);
     *out += len;
     *outlen -= len;
     return 0;
}

int decode_int32(out, outlen, v)
     char **out;
     int *outlen;
     krb5_int32 *v;
{
     int ret;
     int nv;

     if ((ret = decode_bytes(out, outlen, (char *) &nv, sizeof(nv))))
	  return ret;
     *v = ntohl(nv);
     return 0;
}

int decode_v4tkt(v4tkt, buf, encoded_len)
     KTEXT_ST *v4tkt;
     char *buf;
     int *encoded_len;
{
     int buflen, ret;

     buflen = *encoded_len;
     if ((ret = decode_int32(&buf, &buflen, &v4tkt->length)))
	  return ret;
     if ((ret = decode_bytes(&buf, &buflen, (char *)v4tkt->dat, MAX_KTXT_LEN)))
	  return ret;
     if ((ret = decode_int32(&buf, &buflen, (krb5_int32 *) &v4tkt->mbz)))
	  return ret;
     *encoded_len -= buflen;
     return 0;
}

