/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Id: disp_com_err_status.c,v 1.5 1996/07/22 20:32:59 marc Exp $
 */

#include "gssapiP_generic.h"
#include "com_err.h"

/* XXXX internationalization!! */

/**/

static int init_et = 0;
static const char * const no_error = "No error";

/**/

/* if status_type == GSS_C_GSS_CODE, return up to three error messages,
     for routine errors, call error, and status, in that order.
     message_context == 0 : print the routine error
     message_context == 1 : print the calling error
     message_context > 2  : print supplementary info bit (message_context-2)
   if status_type == GSS_C_MECH_CODE, return the output from error_message()
   */

OM_uint32
g_display_com_err_status(minor_status, status_value, status_string)
     OM_uint32 *minor_status;
     OM_uint32 status_value;
     gss_buffer_t status_string;
{
   status_string->length = 0;
   status_string->value = NULL;

   if (!init_et) {
      initialize_ggss_error_table();
      init_et = 1;
   }

   if (! g_make_string_buffer(((status_value == 0)?no_error:
			       error_message(status_value)),
			      status_string)) {
      *minor_status = ENOMEM;
      return(GSS_S_FAILURE);
   }
   *minor_status = 0;
   return(GSS_S_COMPLETE);
}
