/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "gssapiP_krb5.h"
#include "com_err.h"

/* XXXX internationalization!! */

/**/

static int init_et = 0;

/**/

OM_uint32
krb5_gss_display_status(minor_status, status_value, status_type,
			mech_type, message_context, status_string)
     OM_uint32 *minor_status;
     OM_uint32 status_value;
     int status_type;
     gss_OID mech_type;
     OM_uint32 *message_context;
     gss_buffer_t status_string;
{
   krb5_context context;
   status_string->length = 0;
   status_string->value = NULL;

   if (GSS_ERROR(kg_get_context(minor_status, &context)))
      return(GSS_S_FAILURE);

   if ((mech_type != GSS_C_NULL_OID) &&
       (! g_OID_equal(gss_mech_krb5, mech_type))) {
      *minor_status = 0;
      return(GSS_S_BAD_MECH);
   }

   if (status_type == GSS_C_GSS_CODE) {
      return(g_display_major_status(minor_status, status_value,
				    message_context, status_string));
   } else if (status_type == GSS_C_MECH_CODE) {
      if (!init_et) {
	 krb5_init_ets(context);
	 initialize_k5g_error_table();
	 init_et = 1;
      }

      if (*message_context) {
	 *minor_status = (OM_uint32) G_BAD_MSG_CTX;
	 return(GSS_S_FAILURE);
      }

      return(g_display_com_err_status(minor_status, status_value,
				      status_string));
   } else {
      *minor_status = 0;
      return(GSS_S_BAD_STATUS);
   }
}
