/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "gssapiP_krb5.h"

OM_uint32
krb5_gss_inquire_context(minor_status, context_handle, initiator_name, 
			 acceptor_name, lifetime_rec, mech_type, ret_flags,
			 locally_initiated, open)
     OM_uint32 *minor_status;
     gss_ctx_id_t context_handle;
     gss_name_t *initiator_name;
     gss_name_t *acceptor_name;
     OM_uint32 *lifetime_rec;
     gss_OID *mech_type;
     OM_uint32 *ret_flags;
     int *locally_initiated;
     int *open;
{
   krb5_context context;
   krb5_error_code code;
   krb5_gss_ctx_id_rec *ctx;
   krb5_principal init, accept;
   krb5_timestamp now;
   krb5_deltat lifetime;

   if (GSS_ERROR(kg_get_context(minor_status, &context)))
      return(GSS_S_FAILURE);

   if (initiator_name)
      *initiator_name = (gss_name_t) NULL;
   if (acceptor_name)
      *acceptor_name = (gss_name_t) NULL;

   /* validate the context handle */
   if (! kg_validate_ctx_id(context_handle)) {
      *minor_status = (OM_uint32) G_VALIDATE_FAILED;
      return(GSS_S_NO_CONTEXT);
   }

   ctx = (krb5_gss_ctx_id_rec *) context_handle;

   if (! ctx->established) {
      *minor_status = KG_CTX_INCOMPLETE;
      return(GSS_S_NO_CONTEXT);
   }

   init = NULL;
   accept = NULL;

   if (code = krb5_timeofday(context, &now)) {
      *minor_status = code;
      return(GSS_S_FAILURE);
   }

   if ((lifetime = ctx->endtime - now) < 0)
      lifetime = 0;

   if (initiator_name) {
      if (code = krb5_copy_principal(context, 
				     ctx->initiate?ctx->here:ctx->there,
				     &init)) {
	 *minor_status = code;
	 return(GSS_S_FAILURE);
      }
      if (! kg_save_name((gss_name_t) init)) {
	 krb5_free_principal(context, init);
	 *minor_status = (OM_uint32) G_VALIDATE_FAILED;
	 return(GSS_S_FAILURE);
      }
   }

   if (acceptor_name) {
      if (code = krb5_copy_principal(context, 
				     ctx->initiate?ctx->there:ctx->here,
				     &accept)) {
	 if (init) krb5_free_principal(context, init);
	 *minor_status = code;
	 return(GSS_S_FAILURE);
      }
      if (! kg_save_name((gss_name_t) accept)) {
	 krb5_free_principal(context, accept);
	 if (init) {
	    kg_delete_name((gss_name_t) accept);
	    krb5_free_principal(context, init);
	 }
	 *minor_status = (OM_uint32) G_VALIDATE_FAILED;
	 return(GSS_S_FAILURE);
      }
   }

   if (initiator_name)
      *initiator_name = (gss_name_t) init;

   if (acceptor_name)
      *acceptor_name = (gss_name_t) accept;

   if (lifetime_rec)
      *lifetime_rec = lifetime;

   if (mech_type)
      *mech_type = (gss_OID) ctx->mech_used;

   if (ret_flags)
      *ret_flags = ctx->gss_flags;

   if (locally_initiated)
      *locally_initiated = ctx->initiate;

   if (open)
      *open = ctx->established;

   *minor_status = 0;
   return((lifetime == 0)?GSS_S_CONTEXT_EXPIRED:GSS_S_COMPLETE);
}
