/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Id: util_cksum.c,v 1.13 1996/08/28 21:49:24 tytso Exp $
 */

#include "gssapiP_krb5.h"
#include <memory.h>

krb5_error_code
kg_checksum_channel_bindings(context, cb, cksum, bigend)
     krb5_context context;
     gss_channel_bindings_t cb;
     krb5_checksum *cksum;
     int bigend;
{
   int len;
   char *buf, *ptr;
   krb5_error_code code;

   /* initialize the the cksum and allocate the contents buffer */
   cksum->checksum_type = CKSUMTYPE_RSA_MD5;
   cksum->length = krb5_checksum_size(context, CKSUMTYPE_RSA_MD5);
   if ((cksum->contents = (krb5_octet *) xmalloc(cksum->length)) == NULL) {
      return(ENOMEM);
   }
 
   /* generate a buffer full of zeros if no cb specified */

   if (cb == GSS_C_NO_CHANNEL_BINDINGS) {
      memset(cksum->contents, '\0', cksum->length);
      return(0);
   }

   /* create the buffer to checksum into */

   len = (sizeof(krb5_int32)*5+
	  cb->initiator_address.length+
	  cb->acceptor_address.length+
	  cb->application_data.length);

   if ((buf = (char *) xmalloc(len)) == NULL)
      return(ENOMEM);

   /* helper macros.  This code currently depends on a long being 32
      bits, and htonl dtrt. */

   ptr = buf;

   TWRITE_INT(ptr, cb->initiator_addrtype, bigend);
   TWRITE_BUF(ptr, cb->initiator_address, bigend);
   TWRITE_INT(ptr, cb->acceptor_addrtype, bigend);
   TWRITE_BUF(ptr, cb->acceptor_address, bigend);
   TWRITE_BUF(ptr, cb->application_data, bigend);

   /* checksum the data */

   if (code = krb5_calculate_checksum(context, CKSUMTYPE_RSA_MD5, 
				      buf, len, NULL, 0, cksum)) {
      xfree(cksum->contents);
      xfree(buf);
      return(code);
   }

   /* success */

   xfree(buf);
   return(0);
}
