#include <krb5.h>

static krb5_error_code rc_null_init (ctx, r, delta)
     krb5_context ctx;
     krb5_rcache r;
     krb5_deltat delta;
{
  return 0;
}

static krb5_error_code rc_null_op (ctx, r)
     krb5_context ctx;
     krb5_rcache r;
{
  return 0;
}

static krb5_error_code rc_null_store (ctx, r, x)
     krb5_context ctx;
     krb5_rcache r;
     krb5_donot_replay *x;
{
  return 0;
}

static krb5_error_code rc_null_get_span (ctx, r, t)
     krb5_context ctx;
     krb5_rcache r;
     krb5_deltat *t;
{
  *t = 0;
}

static char *rc_null_get_name (ctx, r)
     krb5_context ctx;
     krb5_rcache r;
{
  return 0;
}

static krb5_error_code rc_null_resolve (ctx, r, name)
     krb5_context ctx;
     krb5_rcache r;
     char *name;
{
  return ENOENT;		/* ?? */
}

static krb5_rc_ops rc_null_ops = {
  0,
  0,
  rc_null_init,
  rc_null_op,			/* recover */
  rc_null_op,			/* destroy */
  rc_null_op,			/* close */
  rc_null_store,		/* store */
  rc_null_op,			/* expunge */
  rc_null_get_span,		/* get_span */
  rc_null_get_name,		/* get_name */
  rc_null_resolve,		/* resolve */
};

/* The only exported interface, currently.  */
krb5_error_code krb5_rc_null_generate (ctx, rp)
     krb5_context ctx;
     krb5_rcache *rp;
{
  static struct krb5_rc_st null_rcache = { KV5M_RCACHE, &rc_null_ops, 0 };
  *rp = &null_rcache;
  return 0;
}
