/* KerbNet 1.1
   Copyright (c) 1996-1997 Cygnus Solutions */

#include "k5-int.h"

#define cKrbUserCancelled	2
#define kLoginDLOGID		-4081
#define kErrorALERTID		-4082
#define kLoginOKItem		1
#define kLoginCnclItem		2
#define kLoginNameItem		7
#define kLoginVisPwItem		8
#define kLoginFrameItem		13
#define kLoginIvisPwItem	14
#define kForwardableTicket	12
#define kNonDefaultLifetime	9
#define kLifetimeMinute		10
#define kMinuteText			11
#define kBadUserError		1
#define kNotUniqueError		2
#define kGenError			3
#define kIntegrityError		4
#define kBadPasswordError	5
#define cr 					0x0D
#define enter 				0x03
#define bs 					0x08
#define tab 				0x09
#define larrow 				0x1C
#define rarrow 				0x1D
#define uarrow 				0x1E
#define darrow 				0x1F
#define zero				0x30
#define one					0x31
#define two					0x32
#define three				0x33
#define four				0x34
#define five				0x35
#define six					0x36
#define seven				0x37
#define eight				0x38
#define nine				0x39
#define DialogNotDone 		1

#define kPromptDLOGID		135
#define kPromptOKItem		1
#define kPromptCancelItem	2
#define kPromptFrameItem	3
#define kPromptBannerItem	5
#define kPromptPromptItem	6
#define kPromptRespItem		8
#define kPromptHiddenItem	10

static pascal void FrameOKbtn( WindowPtr myWindow, short itemNo )
{
	short		tempType;
	Handle		tempHandle;
	Rect		itemRect;

	GetDItem( (DialogPtr) myWindow, itemNo, &tempType, &tempHandle, &itemRect );
	PenSize( 3, 3 );
	FrameRoundRect( &itemRect, 16, 16 );		// make it an OK button suitable for framing
}


static pascal Boolean TwoItemFilter( DialogPtr dlog, EventRecord *event, short *itemHit )
{
	DialogPtr	evtDlog;
	short		selStart, selEnd;
	Handle		BtnHandle;
	short		tempType;
	Rect		tempRect;
	long		tempTicks;

	if( event->what != keyDown && event->what != autoKey )
		return false;				// don't care about this event

	switch( event->message & charCodeMask )
	{
	case cr:						// Return  (hitting return or enter is the same as hitting the OK button)
	case enter:						// Enter
	
		if (!OKIsEnabled(dlog)) {
			event->what = nullEvent;
			return false;
		}
		
		GetDItem( dlog, kLoginOKItem, &tempType, &BtnHandle, &tempRect );
		HiliteControl( (ControlHandle) BtnHandle, 1 );	// hilite the button
		Delay( 10, &tempTicks );	// wait a little while
		HiliteControl( (ControlHandle) BtnHandle, 0 );

		*itemHit = kLoginOKItem;	// OK Button
		return true;				// We handled the event

	case tab:						// Tab
	case larrow:					// Left arrow  (Keys that just change the selection)
	case rarrow:					// Right arrow
	case uarrow:					// Up arrow
	case darrow:					// Down arrow
		return false;				// Let ModalDialog handle them

	case 'f':
	case 'l':
		if( event->modifiers & cmdKey ) {	// Click a button
			*itemHit = ((event->message&charCodeMask) == 'f')?kForwardableTicket:kNonDefaultLifetime;
			
			GetDItem( dlog, *itemHit, &tempType, &BtnHandle, &tempRect );
			HiliteControl( (ControlHandle) BtnHandle, 1 );	// hilite the button
			Delay( 10, &tempTicks );	// wait a little while
			HiliteControl( (ControlHandle) BtnHandle, 0 );
	
			return true;				// We handled the event
		} /* otherwise, fall through */

	default:
	
		// First see if we're in password field, do stuff to make  displayed
		
		if( ((DialogPeek) dlog)->editField == kLoginVisPwItem - 1 ) {

			selStart = (**((DialogPeek) dlog)->textH).selStart;	// Get the selection in the visible item
			selEnd = (**((DialogPeek) dlog)->textH).selEnd;

			SelIText( dlog, kLoginIvisPwItem, selStart, selEnd );	// Select text in invisible item
			DialogSelect( event, &evtDlog, itemHit );			// Input key

			SelIText( dlog, kLoginVisPwItem, selStart, selEnd );	// Select same area in visible item
			if( ( event->message & charCodeMask ) != bs )		// If it's not a backspace (backspace is the only key that can affect both the text and the selection- thus we need to process it in both fields, but not change it for the hidden field.
				event->message = '';							// Replace with character to use
		}
		
		// RUJ numeric filter for kLifetimeMinute editText box
		if( ((DialogPeek) dlog)->editField == kLifetimeMinute - 1 ) {
			switch (event->message & charCodeMask) {
				case bs:
				case zero:
				case one:
				case two:
				case three:
				case four:
				case five:
				case six:
				case seven:
				case eight:
				case nine:
					return false;				// Let ModalDialog handle them

				default:
					return true;
			}
		} else {
		// Do the key event and set the hilite on the OK button accordingly
			DialogSelect( event, &evtDlog, itemHit );			// Input key
			SetOKEnable(dlog);
		}

		
		// Pass a NULL event back to DialogMgr
		
		event->what = nullEvent;
		
		return false;
	}
}


static int SetOKEnable( DialogPtr dlog )
{
	short		itemType, state;
	Handle		itemHandle;
	Rect		itemRect;
	Str255		tpswd,tuser;
	ControlHandle okButton;

	GetDItem( dlog, kLoginNameItem, &itemType, &itemHandle, &itemRect );
	GetIText( itemHandle, tuser );
	GetDItem( dlog, kLoginVisPwItem, &itemType, &itemHandle, &itemRect );
	GetIText( itemHandle, tpswd );
	GetDItem( dlog, kLoginOKItem, &itemType, (Handle *) &okButton, &itemRect );
	state = (tuser[0] && tpswd[0]) ? 0 : 255;
	HiliteControl(okButton, state);
}

static int OKIsEnabled( DialogPtr dlog )
{
	short		itemType;
	Rect		itemRect;
	ControlHandle okButton;

	GetDItem( dlog, kLoginOKItem, &itemType, (Handle *) &okButton, &itemRect );
	return ((**okButton).contrlHilite != 255);
}


static void SetNonDefaultMinute( DialogPtr mydlog, int mylstate )
{

	if (mylstate == 1) {
		ShowDItem(mydlog, kLifetimeMinute); /* Make non-default lifetime field active */
		ShowDItem(mydlog, kMinuteText);
	}
	else {
		HideDItem(mydlog, kLifetimeMinute); /* Make non-default lifetime field inactive */
		HideDItem(mydlog, kMinuteText);
	}
}


#define ANAME_SZ			100
#define	INST_SZ				100
#define REALM_SZ			100
#define MAX_K_NAME_SZ		100
#define MAX_MINUTE_SZ		100

OSErr GetUserInfo( char *UserName, char *password, krb5_get_init_creds_opt *opts) 
{
	DialogPtr		myDLOG;
	short			itemHit;
	short			itemType;
	Handle			itemHandle;
	Rect			itemRect;
	OSErr			rc = DialogNotDone;
	Str255			tempStr, tpswd, tuser;
	short			rf;
	char 			uname[ANAME_SZ]="\0";
	char 			uinst[INST_SZ]="\0";
	char 			realm[REALM_SZ]="\0";
	CursHandle		aCursor;
	int 			fstate = 0;				/* forwardable ticket state */
	int 			lstate = 0;				/* non-default lifetime ticket state */
    krb5_error_code code;
   	char 			*MinuteStr = NULL;
   	
   	
	/////////////////////////
	// Ask user for password
	/////////////////////////
	password[0] = 0;
	myDLOG = GetNewDialog( kLoginDLOGID, (void *) NULL, (WindowPtr) -1 );
	if( myDLOG == NULL ) {
		return -1;
	}

	// Insert user's name in dialog
	if (*UserName) {
		tempStr[0] = strlen(UserName);
		memcpy( &(tempStr[1]), UserName, tempStr[0]);
		GetDItem( myDLOG, kLoginNameItem, &itemType, &itemHandle, &itemRect );
		SetIText( itemHandle, tempStr );
		SelIText( myDLOG, kLoginVisPwItem,0,0 );
	}
	else SelIText( myDLOG, kLoginNameItem,0,0 );
	
	// Establish a user item around the OK button to draw the default button frame in
	GetDItem( myDLOG, kLoginOKItem, &itemType, &itemHandle, &itemRect );
	InsetRect( &itemRect, -4, -4 );				// position user item around OK button
	SetDItem( myDLOG, kLoginFrameItem, userItem, (Handle)FrameOKbtn, &itemRect );
	
	InitCursor();
	do {
		do {										// display the dialog & handle events
			SetOKEnable(myDLOG);
			SetNonDefaultMinute(myDLOG, lstate);
				
			ModalDialog(TwoItemFilter, (short *) &itemHit );
			switch (itemHit) {
			case kForwardableTicket:
				fstate ^= 1;
				GetDItem(myDLOG, kForwardableTicket, &itemType, &itemHandle, &itemRect);
				SetCtlValue((ControlHandle)itemHandle, fstate);
				break;

			case kNonDefaultLifetime:
				lstate ^= 1;
				GetDItem(myDLOG, kNonDefaultLifetime, &itemType, &itemHandle, &itemRect);
				SetCtlValue((ControlHandle)itemHandle, lstate);
				SetNonDefaultMinute(myDLOG, lstate);
				break;
			}
		} while( itemHit != kLoginOKItem && itemHit != kLoginCnclItem );
		
		if( itemHit == kLoginOKItem ) {				// OK button pressed?			
			GetDItem( myDLOG, kLoginNameItem, &itemType, &itemHandle, &itemRect );
			GetIText( itemHandle, tempStr );
		
			tempStr[0] = ( tempStr[0] < MAX_K_NAME_SZ ) ? tempStr[0] : MAX_K_NAME_SZ-1 ;
			memcpy ((void*) UserName, (void*) &(tempStr[1]), tempStr[0]);
			UserName[tempStr[0]] = 0;
			
			GetDItem( myDLOG, kLoginIvisPwItem, &itemType, &itemHandle, &itemRect );
			GetIText( itemHandle, tempStr );
		
			tempStr[0] = ( tempStr[0] < ANAME_SZ ) ? tempStr[0] : ANAME_SZ-1 ;
			memcpy( (void*) password, (void*) &(tempStr[1]), tempStr[0]);
			password[tempStr[0]] = 0;
			
			if (lstate) {
				krb5_deltat lifetime;
				
				GetDItem( myDLOG, kLifetimeMinute, &itemType, &itemHandle, &itemRect );// Get Non-default lifetime value entered by user
				GetIText( itemHandle, tempStr );
		
				tempStr[0] = ( tempStr[0] < MAX_MINUTE_SZ ) ? tempStr[0] : MAX_MINUTE_SZ-1 ;
				memcpy( (void*) MinuteStr, (void*) &(tempStr[1]), tempStr[0]);
				MinuteStr[tempStr[0]] = 0;
				strncat(MinuteStr, "m", 1);  //RUJ Append character m to the end of MinuteStr to satisfy deltat_table[] in krb5_string_to_deltat
				
				code = krb5_string_to_deltat(MinuteStr, &lifetime);
	    		if (code != 0 || lifetime == 0)
					doalert("Bad lifetime value %d", MinuteStr);
				
				krb5_get_init_creds_opt_set_tkt_life(opts, lifetime);
	    	}
			krb5_get_init_creds_opt_set_forwardable(opts, fstate);

			rc = !DialogNotDone;
		}
		else rc = cKrbUserCancelled;						// pressed the Cancel button
	} while( rc == DialogNotDone );

	DisposDialog( myDLOG );
	return rc;
}


static int ghidden[2];
static char *gbanner, *gprompts[2];

static pascal Boolean krb5_prompt_filter(DialogPtr dlg, EventRecord *event, short *item)
{
	short selStart, selEnd, t, field;
	Handle h;
	Rect r;
	long tempTicks;
	DialogPeek dp;

	if(event->what != keyDown && event->what != autoKey) return false;

	switch(event->message & charCodeMask) {
		case cr:
		case enter:
			GetDItem(dlg, kPromptOKItem, &t, &h, &r );
			HiliteControl((ControlHandle)h, 1);
			Delay(10, &tempTicks);
			HiliteControl((ControlHandle)h, 0);
	
			*item = kPromptOKItem;
			return true;
	
		case tab:
		case larrow:
		case rarrow:
		case uarrow:
		case darrow:
			return false;				/* Let ModalDialog handle them */
	
		default:
			dp = (DialogPeek)dlg;
			field = dp->editField+1;
		
			/* First see if we're in a hidden field, do stuff to make  displayed */
			
			if((field == kPromptRespItem && ghidden[0]) || 
			   (field == kPromptRespItem+1 && ghidden[1])) {
	
				selStart = (**dp->textH).selStart;	// Get the selection in the visible item
				selEnd = (**dp->textH).selEnd;
	
				SelIText( dlg, field+(kPromptHiddenItem-kPromptRespItem), selStart, selEnd );	// Select text in invisible item
				DialogSelect( event, &dlg, item );			// Input key
	
				SelIText( dlg, field, selStart, selEnd );	// Select same area in visible item
				if( ( event->message & charCodeMask ) != bs )		// If it's not a backspace (backspace is the only key that can affect both the text and the selection- thus we need to process it in both fields, but not change it for the hidden field.
					event->message = '';							// Replace with character to use
			}
			
			/* Do the key event and set the hilite on the OK button accordingly */
			DialogSelect( event, &dlg, item );			// Input key
			
			// Pass a NULL event back to DialogMgr
			
			event->what = nullEvent;
			
			return false;
	}
}

/* draw proc for our variably-sized text boxes */
static pascal void krb5_prompt_draw_text(DialogPtr dlg, short item)
{
	Rect r;
	Handle h;
	short t;
	char *text;
	
	if(item == kPromptBannerItem) text=gbanner;
	else text=gprompts[item-kPromptPromptItem];

	GetDialogItem(dlg, item, &t, &h, &r);
	TETextBox(text, strlen(text), &r, teFlushDefault);
}

int krb5_prompter_mac(krb5_context context, void *data, const char *banner,
	int num_prompts, krb5_prompt prompts[])
{
	Str255 tmp;
	short t, item, i, delta, xdelta;
	Handle h;
	Rect r;
	DialogPtr dlg;
	char *p;
	TEHandle teh;
	
	if(num_prompts>2) {
		SysBeep(1);
		return KRB5KRB_AP_ERR_BADVERSION; /* as in ``funny, I didn't know there were any
											 prompter calls with more than 2 arguments...'' */
	}
	
	/* convert LFs to CRs and stash pointers in globals vars for callback to use later.
	   (We say \012 and \015 instead of \n and \r to be independent of the -mapcr compiler option) */
	for(p=gbanner=banner; *p; p++)
		if(*p=='\012') *p='\015';
	if(p>banner && *(p-1)=='\015') *(p-1)=='\0';
	
	for(i=0; i<num_prompts; i++)
		for(p=gprompts[i]=prompts[i].prompt, ghidden[i]=prompts[i].hidden; *p; p++)
			if(*p=='\012') *p='\015';
	
	dlg = GetNewDialog(kPromptDLOGID, NULL, (WindowPtr)(-1));
	if(!dlg) return ENOMEM;

	/* Build text object for banner and resize dialog box */
	GetDialogItem(dlg, kPromptBannerItem, &t, &h, &r);
	teh = TENew(&r, &r);
	TESetText(banner, strlen(banner), teh);
	delta = (*teh)->lineHeight*(*teh)->nLines - (r.bottom - r.top);
	if(delta<0) delta = 0;
	TEDispose(teh);
	r.bottom += delta;
	SetDialogItem(dlg, kPromptBannerItem, t, (Handle)krb5_prompt_draw_text, &r);
	
	/* Now do the same for any prompts (and realign them with the updated dbox) */
	for(i=0; i<num_prompts; i++) {
		/* move response edit box */
		GetDialogItem(dlg, kPromptRespItem+i, &t, &h, &r);
		r.top += delta;
		r.bottom += delta;
		SetDialogItem(dlg, kPromptRespItem+i, t, h, &r);
		
		/* move/resize prompt string */
		GetDialogItem(dlg, kPromptPromptItem+i, &t, &h, &r);
		r.top += delta;
		r.bottom += delta;
		teh = TENew(&r, &r);
		TESetText(prompts[i].prompt, strlen(prompts[i].prompt), teh);
		xdelta = (*teh)->lineHeight*(*teh)->nLines - (r.bottom - r.top);
		if(xdelta<0) xdelta = 0;
		TEDispose(teh);
		r.bottom += xdelta;
		SetDialogItem(dlg, kPromptPromptItem+i, t, (Handle)krb5_prompt_draw_text, &r);
		delta += xdelta;
	}
	
	/* Hide the unused parts and reduce delta accordingly to close up the space they'd take */
	for(; i<2; i++) {
		HideDialogItem(dlg, kPromptPromptItem+i);
		HideDialogItem(dlg, kPromptRespItem+i);
		delta -= 30;
	}
	
	/* Now the buttons. (Do the outline around OK while we're here) */
	GetDialogItem(dlg, kPromptOKItem, &t, &h, &r);
	r.top += delta;
	r.bottom += delta;
	SetDialogItem(dlg, kPromptOKItem, t, h, &r);
	MoveControl((ControlHandle)h, r.left, r.top);
	InsetRect(&r, -4, -4);
	SetDialogItem(dlg, kPromptFrameItem, userItem, (Handle)FrameOKbtn, &r);

	/* 'Cancel' is only meaningful if we're being asked for info */
	if(num_prompts) {
		GetDialogItem(dlg, kPromptCancelItem, &t, &h, &r);
		r.top += delta;
		r.bottom += delta;
		SetDialogItem(dlg, kPromptCancelItem, t, h, &r);
		MoveControl((ControlHandle)h, r.left, r.top);
	} else {
		HideDialogItem(dlg, kPromptCancelItem);
	}

	/* Now resize the window to fit everything */
	SizeWindow(dlg, dlg->portRect.right - dlg->portRect.left,
			   dlg->portRect.bottom - dlg->portRect.top + delta, FALSE);
	if(num_prompts) SelIText(dlg, kPromptRespItem, 0, 0);
	
	InitCursor();
	ShowWindow(dlg);

	do {										// display the dialog & handle events
		ModalDialog(krb5_prompt_filter, &item);
	} while(item != kPromptOKItem && item != kPromptCancelItem);
	
	if(item == kPromptOKItem) {
		for(i=0; i<num_prompts; i++) {
			GetDItem(dlg, prompts[i].hidden?kPromptHiddenItem+i:kPromptRespItem+i, &t, &h, &r);
			GetIText(h, tmp);
		
			if(*tmp > prompts[i].reply->length) *tmp=prompts[i].reply->length;
			else prompts[i].reply->length = *tmp;
			strncpy(prompts[i].reply->data, tmp+1, *tmp);
			prompts[i].reply->data[*tmp]='\0';
		}
		DisposDialog(dlg);
		return 0;
	} else {
		DisposDialog(dlg);
		return -1;
	}
}
