#include <stdio.h>
#include "getopt.h" 

/* Stuff for getopt */
static struct option long_options[] = {
	{ "simple", 0, NULL, 's' },
	{ "t", 0, NULL, 't' },
	{ "u", 1, NULL, 'u' },
	{ "v", 0, NULL, 'v' },
	/* Do not reorder the following */
	{ "yy", 0, NULL, 'Y' },
	{  "y", 0, NULL, 'y' },
	{ "zz", 0, NULL, 'z' },
	{ "zzz", 0, NULL, 'Z' },
	{ NULL, 0, NULL, 0 }
};
extern char * optarg;
extern int optreset;
extern int optind;

int debug = 0;

int test_getopt_long(args, expected_result)
    char ** args, * expected_result;
{
	char actual_result[256];
	int count, pass, i;

	pass = 0;
	optind = 1;
	optreset = 1;
	for (count = 0; args[count]; count++);
	while ((i = getopt_long(count, args, "ab:", long_options, NULL)) != EOF) {
		switch(i) {
		case 'u':
			if (strcmp(optarg, "bogus")) {
				printf("%s --u option does not have bogus optarg.\n");
				return(1);
			}
		case 'Y':
		case 's':
		case 't':
		case 'v':
		case 'y':
		case 'z':
			actual_result[pass++] = i;
			break;
		default:
			actual_result[pass++] = '?';
			break;
		}
	}

	actual_result[pass] = '\0';
	return(strcmp(actual_result, expected_result));
	
}

int usage(value)
	int value;
{
	printf("test_getopt [-d]\n");
	exit(value);
}

/*
 * Static arglists for individual tests 
 * This is ugly and maybe I should just use a variable arglist 
 */
char *argv1[] = { "Test simple", "--s", NULL };
char *argv2[] = { "Test multiple", "--s", "--t", NULL };
char *argv3[] = { "Test optarg with space", "--u", "bogus", NULL };
char *argv4[] = { "Test optarg with equal", "--u=bogus", NULL };
char *argv5[] = { "Test complex", "--s", "--t", "--u", "bogus", "--v", NULL };
char *argv6[] = { "Test exact", "--y", NULL };
char *argv7[] = { "Test abbr", "--z", NULL };
char *argv8[] = { "Test simple termination", "--z", "foo", "--z", NULL };
char *argv9[] = { "Test -- termination", "--z", "--", "--z", NULL };

int main(argc, argv) 
    int argc;
    char ** argv;
{
	int i;

	/* Of course if getopt() has a bug this won't work */
	while ((i = getopt(argc, argv, "d")) != EOF) {
		switch(i) {
		case 'd':
			debug++;
			break;
		default:
			usage(1);
			break;
		}
	}

	/* Test getopt_long() */
	{
		if (test_getopt_long(argv1, "s")) {
			printf("Test simple failed.\n");
			exit(1);
		}
	}

	/* Test multiple arguments */
	{
		if (test_getopt_long(argv2, "st")) {
			printf("Test multiple failed.\n");
			exit(1);
		}
	}

	/* Test optarg with space */
	{
		if (test_getopt_long(argv3, "u")) {
			printf("Test optarg with space failed.\n");
			exit(1);
		}
	}

	/* Test optarg with equal */
	{
		if (test_getopt_long(argv4, "u")) {
			printf("Test optarg with equal failed.\n");
			exit(1);
		}
	}

	/* Test complex */
	{
		if (test_getopt_long(argv5, "stuv")) {
			printf("Test complex failed.\n");
			exit(1);
		}
	}

	/* Test that exact matches override abbr matches */
	{
		if (test_getopt_long(argv6, "y")) {
			printf("Test exact failed.\n");
			exit(1);
		}
	}

	/* Test that abbr matches are first match. */
	{
		if (test_getopt_long(argv7, "z")) {
			printf("Test abbr failed.\n");
			exit(1);
		}
	}

	/* Test that option termination succeeds */
	{
		if (test_getopt_long(argv8, "z")) {
			printf("Test simple termination failed.\n");
			exit(1);
		}
	}

	/* Test that "--" termination succeeds */
	{
		if (test_getopt_long(argv9, "z")) {
			printf("Test -- termination failed.\n");
			exit(1);
		}
	}
	exit(0);
}
