/*
 * Copyright 1997 Cygnus Solutions.
 */

#if defined(HAVE_SETUTXENT) && !defined(HAVE_GETUTMPX)
#include <sys/types.h>

#include <string.h>
#include <utmp.h>
#ifdef HAVE_UTMPX_H
#include <utmpx.h>
#endif

void
getutmpx(struct utmp *utmp, struct utmpx *utmpx)
{
  memset(utmpx, 0, sizeof(struct utmpx));

  memcpy(utmpx->ut_user, utmp->ut_user, sizeof(utmp->ut_user));
  memcpy(utmpx->ut_id, utmp->ut_id, sizeof(utmp->ut_id));
  memcpy(utmpx->ut_line, utmp->ut_line, sizeof(utmp->ut_line));
  utmpx->ut_pid = utmp->ut_pid;
  utmpx->ut_type = utmp->ut_type;
  utmpx->ut_exit.__e_termination = utmp->ut_exit.e_termination;
  utmpx->ut_exit.__e_exit = utmp->ut_exit.e_exit;
  utmpx->ut_tv.tv_sec = utmp->ut_time;
  memcpy(utmpx->ut_host, utmp->ut_host, sizeof(utmp->ut_host));
  utmpx->ut_addr = utmp->ut_addr;
}

#endif
