/*
 * rm.c
 *
 * For each argument on the command line, remove it.  Should expand
 * DOS wildcards correctly.
 *
 * Syntax: rm list...
 */
#include <stdio.h>
#include <io.h>
#include <string.h>

void remove_files(char *);

int
main(int argc, char *argv[])
{
  int i;

  if (argc < 2) {
    fprintf(stderr, "Usage:  rm [list]\n");
    return 1;
  }

  for (i = 1 ; i < argc ; i++)
    remove_files(argv[i]);

  return 0;
}

void
remove_files(char *f)
{
  long ff;
  struct _finddata_t fdt;
  char *slash;
  char filepath[256];
  char target[256];

  /*
   * We're unix based quite a bit here.  Look for normal slashes and
   * make them reverse slashes.
   */
  while((slash = strrchr(f, '/')) != NULL)
    *slash = '\\';

  strcpy(filepath, f);

  slash = strrchr(filepath, '\\');

  if (slash) {
    slash++;
    *slash = 0;
  } else {
    filepath[0] = '\0';
  }

  ff = _findfirst(f, &fdt);

  if (ff < 0)
    return;

  sprintf(target, "%s%s", filepath, fdt.name);
  remove(target);
  
  for (;;) {
    if (_findnext(ff, &fdt) < 0)
      break;
    sprintf(target, "%s%s", filepath, fdt.name);
    remove(target);
  }
  _findclose(ff);
}
