import java.awt.*;
import java.applet.Applet;
import java.io.*;

public class PGPMailer extends Applet implements Runnable {
TextField tTo, tFrom, tSubj;
TextArea tMes;
TextField tStat;
Button butKey, butCry, butSnd;
PGPKeyClient pgpkc;
String mailhost;
StrongRandom rnd;

String urlname =
  "http://www.rain.org/~hal/java/pgp/keyproxy.cgi";

public void init()
{
    mailhost = getParameter("mailhost");
    if (mailhost==null) {
        mailhost = getCodeBase().getHost();
    }
    if (getParameter("keyURL") != null)
        urlname = getParameter("keyURL");
    
    tTo = new TextField();
    tFrom = new TextField();
    tSubj = new TextField();
    tMes = new TextArea();
    tStat = new TextField();
    tStat.setEditable(false);
    butKey = new Button("Get key");
    butCry = new Button("Encrypt");
    butSnd = new Button("Send");

    Panel ptop = new Panel();
    ptop.setLayout(new GridBagLayout());
    constrain(ptop, new Label("To:"), 0, 0, 1, 1, .1, 1.);
    constrain(ptop, tTo, 1, 0, 1, 1, 8., 1.);
    constrain(ptop, butKey, 2, 0, 1, 1, .1, 1.);
    constrain(ptop, new Label("From:"), 0, 1, 1, 1, .1, 1.);
    constrain(ptop, tFrom, 1, 1, 1, 1, 8., 1.);
    constrain(ptop, new Label("Subject:"), 0, 2, 1, 1, .1, 1.);
    constrain(ptop, tSubj, 1, 2, 2, 1, 8., 1.);
    constrain(ptop, new Label("Message:"), 0, 3, 1, 1, .1, 1.);

    setLayout(new BorderLayout());
    add("North", ptop);
    add("Center", tMes);
    Panel pbot = new Panel();
    pbot.setLayout(new GridBagLayout());
    constrain(pbot, butCry, 0, 0, 1, 1, .1, 1.);
    constrain(pbot, butSnd, 1, 0, 1, 1, .1, 1.);
    constrain(pbot, tStat,  2, 0, 1, 1, 8., 1.);
    add("South", pbot);

    pgpkc = new PGPKeyClient(urlname, tStat);
    rnd = new StrongRandom();
}

public void start()
{
    new Thread(this).start();   // make sure our classes are loaded
}

// preload a bunch of classes we will use later
public void run()
{
    try {
        Class.forName("Bignum");
        Class.forName("BlockTransformation");
        Class.forName("Idea");
        Class.forName("CFBEncryption");
        Class.forName("Feedback");
        Class.forName("Mode");
        Class.forName("PGPBase64CRC");
        Class.forName("PGPBignumIO");
        Class.forName("PGPCTB");
        Class.forName("PGPConvKey");
        Class.forName("PGPPublicKey");
        Class.forName("SMTPStream");
        Class.forName("bytes");
        Class.forName("StrongRandom");
        Class.forName("RandSpinner");
    } catch (ClassNotFoundException e) {
        showStatus("Unable to load a necessary class: "+e.toString());
    }
}

// Helper function for grid bag layout
protected void constrain(Container container, Component component,
                        int x, int y, int w, int h, double wx, double wy)
{
    GridBagConstraints c = new GridBagConstraints();
    c.gridx = x; c.gridy = y; c.gridwidth = w; c.gridheight = h;
    c.fill = GridBagConstraints.BOTH; c.anchor = GridBagConstraints.CENTER;
    c.weightx = wx; c.weighty = wy;
    ((GridBagLayout)container.getLayout()).setConstraints(component,c);
    container.add(component);
}

public boolean action(Event e, Object o)
{
    if (e.target instanceof Button) {
        if (e.target==butKey) {
            if (!pgpkc.ready()) {
//                pgpkc.dispose();
                pgpkc = new PGPKeyClient(urlname, tStat);
            }
            pgpkc.getKey(tTo.getText());
            tStat.setText("Getting key for "+tTo.getText());
            return true;
        } else if (e.target==butCry) {
            if (pgpkc==null || !pgpkc.gotKey()) {
                tStat.setText("Key not available for encryption");
                return true;
            }
            try {
                byte ba[] = canonicalString(tMes.getText());
                ByteArrayInputStream is = new ByteArrayInputStream(ba);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PGPBase64OutputStream out = new PGPBase64OutputStream(os, "MESSAGE");
                PGPPublicKey key = pgpkc.toPGPKey();
//                pgpkc.dispose();
                key.encrypt(is, out, rnd);
                out.close();
                tMes.setText(new String(os.toByteArray(),0));
            } catch (Exception ex) {
                tMes.setText("Error: "+ex.toString());
            }
            return true;
        } else if (e.target==butSnd) {
            SMTPStream sms = new SMTPStream();
            tStat.setText ("Sending mail");
            try {
                sms.Connect(mailhost);
                tStat.setText("Sending mail (contacted mail host)");
                sms.Meet();
                sms.SendMessage(tFrom.getText(), tTo.getText(),
                            tSubj.getText(), tMes.getText());
                sms.Disconnect();
                tStat.setText ("Mail sent");
            } catch (Exception ex) {
                tStat.setText("Mail connection failed: " + ex.toString());
                return true;
            }
            return true;
        }
    }
   return false;
}

public boolean handleEvent(Event e)
{
    if (rnd!=null)
        rnd.mixin(e);
    return super.handleEvent(e);
}


protected byte[] canonicalString(String t)
{
    StringBuffer sb = new StringBuffer((t.length()*11) / 10);
    int ti = 0;
    int nti;
    for ( ; ; ) {
        nti = t.indexOf('\n', ti);
        if (nti < 0)
            break;
        sb.append(t.substring(ti, nti));
        sb.append('\r');
        sb.append('\n');
        ti = nti + 1;
    }
    sb.append(t.substring(ti));
    int len = sb.length();
    t = sb.toString();
    byte b[] = new byte[len];
    t.getBytes(0, len, b, 0);
    return b;
}


}
