 DumpKeyRing.cpp{DumpKeyRing.cppHpD    (TEXTCWIE )      Mr  {}c{                       ]  //------------------------------------------------------------------------------------
//
//	DumpKeyRing
//  Iterating through a KeyRing
//
//	by Vinnie Moscaritolo, <vinnie@pgp.com>
//	PGP Developer Technical Support
//
//	File: DumpKeyRing.c
//
//	Copyright  1997 Pretty Good Privacy, Inc.
//	All rights reserved.
//
// You may incorporate this sample code into your licensed PGPsdk applications,
// though the sample code has been provided "AS IS" and the responsibility for
// its operation is 100% yours.
//
//------------------------------------------------------------------------------------

// If this is Microsoft Visual C++, disable warnings about unknown pragmas 
// such as #pragma mark

#ifdef _MSC_VER
#pragma warning(disable:4068)
#endif

//------------------------------------------------------------------------------------
#pragma mark Includes
//------------------------------------------------------------------------------------
//
#include <stdio.h>
#include <time.h>
#include <string.h>

#ifdef __MWERKS__
 	#include <console.h>
 	#include <sioux.h>
	#include <StandardFile.h>
#endif

#ifdef SystemSixOrLater				// Check for a Mac system define
#define PGP_MACINTOSH 1
#else
#define PGP_MACINTOSH 0
#endif

#include "pgpFeatures.h"
#include "pgpEncode.h"
#include "pgpKeys.h"
#include "pgpErrors.h"
#include "pgpUtilities.h"

//------------------------------------------------------------------------------------
#pragma mark Useful Macros
//------------------------------------------------------------------------------------

#define ThrowIfPGPErr(_thetest_)	\
		{ PGPError _err_  = _thetest_; if IsPGPError(_err_) throw _err_ ;}

#define ThrowPGPErr(_err_)		\
			{ throw _err_ ; }

//------------------------------------------------------------------------------------
#pragma mark Prototypes
//------------------------------------------------------------------------------------
void PrintKeyPrefInfo(PGPKeyRef theKeyRef);
void PrintPrimaryKeyInfo (PGPKeyRef theKeyRef);
void PrintSubKeyInfo (PGPSubKeyRef theSubKeyRef);
void FormatFingerprintString(char *p, PGPByte *inBuffp, PGPSize len );

//------------------------------------------------------------------------------------
void main(int argc, char **argv)
//------------------------------------------------------------------------------------
//
//
	{
// Initialize allocatable storage to  kInvalidPGP..
	PGPFileSpecRef	theFileSpec		= kInvalidPGPFileSpecRef;
	PGPContextRef	theContextRef	= kInvalidPGPContextRef;
	PGPKeySetRef 	theKeySetRef	= kInvalidPGPKeySetRef;
	PGPKeyListRef	theKeyListRef	= kInvalidPGPKeyListRef;
	PGPKeyIterRef	theIterator	    = kInvalidPGPKeyIterRef;

// non allocatable storage
	PGPKeyRef		theKeyRef		= kInvalidPGPKeyRef;
	PGPSubKeyRef	theSubKeyRef	= kInvalidPGPSubKeyRef;
	PGPUserIDRef	theUserIDRef	= kInvalidPGPUserIDRef;
	PGPSigRef		theSigRef		= kInvalidPGPSigRef;

	PGPError 		err 			= kPGPError_NoErr;

	char			sdkInfo[256];
	char			primaryUsernamebuf[256];

#if __MWERKS__
	extern tSIOUXSettings	SIOUXSettings;
	SIOUXSettings.asktosaveonclose = false;
	SIOUXSettings.rows = 40;

	argc = ccommand(&argv);
#endif

	char		*file = NULL;
	PGPBoolean	keyRingFile = FALSE;
	PGPBoolean	dumpCerts	= FALSE;
	PGPBoolean	dumpDefault	= FALSE;

	int			i,j;

// do siilly unix like  param bashing
//  -k file  -- keyring file
//  -a file  --  ascii armored keyblock file
//  -d       --  use default keyring file
//  -s       --  dump certifiers

#ifdef __MWERKS__
#else
	if (argc == 1)
		goto usage;
#endif

	for (i = 1; i < argc; i++)
		if (argv[i][0] == '-')
			for (j=0; argv[i][j] !=' ' && argv[i][j] != '\0';j++) {
				if ( argv[i][j] == 'd') {
					dumpDefault = TRUE;
				} else if ( argv[i][j] == 's') {
					dumpCerts = TRUE;
				} if ( argv[i][j] == 'k' && i < argc ) {
					if (file != NULL) {
						goto usage;
					}
					file = argv[i+1];
					keyRingFile = TRUE;
				} else if ( argv[i][j] == 'a' && i < argc ) {
					if (file != NULL) {
						goto usage;
					}
					file = argv[i+1];
				}
			}

	try
		{
// Print SDK version Info
		ThrowIfPGPErr(PGPGetSDKString(sdkInfo) )
		printf("DumpKeyRing: Iterating through the KeyRing\n%s\n",sdkInfo);

// Create a new PGP context
		ThrowIfPGPErr( PGPNewContext( kPGPsdkAPIVersion, &theContextRef ) );

	if(dumpDefault)
// Open the Default Keyrings
		ThrowIfPGPErr( PGPOpenDefaultKeyRings(theContextRef, FALSE, &theKeySetRef) )
	else
		{
#if PGP_MACINTOSH
	// Query for a keyfile or text file for import
			FSSpec spec;
			StandardFileReply  reply;
			OSType typeList[]	 =
{'PKey','SKey','pgRR','pgPR','TEXT'};

			StandardGetFile(NULL, 5,
(ConstSFTypeListPtr)typeList, &reply);
			if(!reply.sfGood ) ThrowPGPErr(kPGPError_NoErr);

			ThrowIfPGPErr(
PGPNewFileSpecFromFSSpec(theContextRef, &reply.sfFile, &theFileSpec) );
			if( reply.sfType != 'TEXT') keyRingFile = TRUE;
#else
	// convert text pathname to PGP spec
			ThrowIfPGPErr(PGPNewFileSpecFromFullPath(theContextRef, file, &theFileSpec) );
#endif

			if( keyRingFile == TRUE )
// Open a specific Keyring
				ThrowIfPGPErr(PGPOpenKeyRing(theContextRef,kPGPKeyRingOpenFlags_Trusted, theFileSpec,&theKeySetRef ))
			else
// Import a Keyring
				{
				ThrowIfPGPErr( PGPImportKeySet(theContextRef, &theKeySetRef,

	 			PGPOInputFile( theContextRef, theFileSpec),

	 			PGPOLastOption(theContextRef) ));
			// In order look at anything that is self signed, you must check the Sigs only against itself

				ThrowIfPGPErr( PGPCheckKeyRingSigs(theKeySetRef,theKeySetRef, FALSE, NULL, 0));
				ThrowIfPGPErr(PGPPropagateTrust(theKeySetRef));
				}
		}


// Sort the key Set in UserID ordering
		ThrowIfPGPErr( PGPOrderKeySet(theKeySetRef,kPGPUserIDOrdering, &theKeyListRef));

// Create an Key Iterator for this Keyset
		ThrowIfPGPErr( PGPNewKeyIter( theKeyListRef, &theIterator ));

// Iterate through the key set
		while( IsntPGPError(err = PGPKeyIterNext( theIterator,&theKeyRef )))
			{

	printf("\n---------------------------------------------------------------------\n\n");

	// Print Primary User Name

			ThrowIfPGPErr(PGPGetPrimaryUserIDNameBuffer(theKeyRef, sizeof primaryUsernamebuf,primaryUsernamebuf, NULL ));
			printf("%s\n", primaryUsernamebuf);

		PrintKeyPrefInfo(theKeyRef);
		PrintPrimaryKeyInfo(theKeyRef);

	// Print Info on any Subkeys

			while( IsntPGPError(err = PGPKeyIterNextSubKey(theIterator, &theSubKeyRef )) && ( theSubKeyRef != NULL) )
				{
					PrintSubKeyInfo(theSubKeyRef);
				}
			if( err != kPGPError_EndOfIteration) ThrowIfPGPErr(err);
			err = kPGPError_NoErr;

	// Print Info on Message recovery Keys
			{
				PGPUInt32 	index, numMRKeys;
				PGPKeyRef	theMRKeyRef;
				PGPByte		theClass;
				char		MRKnamebuf[256];

				ThrowIfPGPErr(PGPGetNumMessageRecoveryKeys(theKeyRef, theKeySetRef, &numMRKeys));
				if(numMRKeys> 0)
					{
						printf("\tMessage Recovery Keys:\n", numMRKeys);
						for (index = 0; index <numMRKeys; index++)
						 	if(IsntPGPError(err = PGPGetIndexedMessageRecoveryKey(theKeyRef,theKeySetRef, index, &theMRKeyRef, &theClass)))
							{

	ThrowIfPGPErr( PGPGetPrimaryUserIDNameBuffer(theMRKeyRef, sizeof(MRKnamebuf), MRKnamebuf, NULL ));
								printf("\t%s %s\n",MRKnamebuf, ((theClass & 0x80)?"(Enforced)":""));
							}
							else if(err == kPGPError_RecoveryKeyNotFound )
							{
								PGPKeyIDRef theMRKeyIDRef	 = kInvalidPGPKeyIDRef;
								char *mrkIDString = NULL;

								err = PGPGetIndexedMessageRecoveryKeyID(theKeyRef,theKeySetRef, index, &theMRKeyIDRef, &theClass );
								(void) PGPGetKeyIDString(theMRKeyIDRef, kPGPKeyIDString_Abbreviated, &mrkIDString);

	if(mrkIDString)	printf("\t     Unknown Key, Key ID is %s %s\n", mrkIDString, ((theClass & 0x80)?"(Enforced)":""));

	if(mrkIDString) PGPFreeData (mrkIDString);
								if(PGPKeyIDRefIsValid( theMRKeyIDRef)) PGPFreeKeyID(theMRKeyIDRef);
							}
							else ThrowPGPErr(err);

	printf("\t------------------------------------------------------------------\n");
					}
			}


	// Print User ids & certs
			{
				char userNamebuf[256];

			// Iterate through User IDs
				while( IsntPGPError(err = PGPKeyIterNextUserID(theIterator, &theUserIDRef )) && ( theUserIDRef != NULL) )
					{
			// print the User Name only if its not the same as primary User Name
					PGPGetUserIDStringBuffer(theUserIDRef, kPGPUserIDPropName, sizeof(userNamebuf), userNamebuf, NULL );
					if(PGPCompareUserIDStrings(primaryUsernamebuf, userNamebuf))
						{
							printf("\t%s\n", userNamebuf);
						};
			// Iterate through key certifiers
					if(dumpCerts) {
						while( IsntPGPError(err = PGPKeyIterNextUIDSig(theIterator, &theSigRef )) && ( theSigRef != NULL) )
							{
							char		certNamebuf[256];
							PGPKeyRef	certKey = NULL;

				// if  have this signer in our keychain, then print it primary name
							if( IsntPGPError(PGPGetSigCertifierKey(theSigRef, theKeySetRef, &certKey)) && (certKey != NULL ))
									{

	ThrowIfPGPErr( PGPGetPrimaryUserIDNameBuffer(certKey, sizeof certNamebuf, certNamebuf, NULL ));
								printf("\t--S> %s\n", certNamebuf);
								}
							else
				// otherwise just show key ID
								{
								PGPKeyIDRef certIDRef	 = kInvalidPGPKeyIDRef;
								char *certIDString = NULL;
								(void) PGPNewKeyIDOfCertifier(theSigRef, &certIDRef);
								(void) PGPGetKeyIDString(certIDRef, kPGPKeyIDString_Abbreviated, &certIDString);

	if(certIDString)	printf("\t  --S> Unknown Signer, Key ID is %s\n", certIDString);

	if(certIDString) PGPFreeData (certIDString);
								if(PGPKeyIDRefIsValid( certIDRef)) PGPFreeKeyID(certIDRef);
								}
							}
						if( err != kPGPError_EndOfIteration) ThrowIfPGPErr(err);
						err = kPGPError_NoErr;
						}
					}
				if( err != kPGPError_EndOfIteration) ThrowIfPGPErr(err);
				err	= kPGPError_NoErr;
				}
			};	// Iterating through Keyset

		if( err != kPGPError_EndOfIteration) ThrowPGPErr(err);
		err	= kPGPError_NoErr;


	printf("\n---------------------------------------------------------------------\n");

		}

// Error Reporting
	catch (PGPError &ex)
		{
			char			errorbuf[256];
			PGPGetErrorString ( ex, sizeof(errorbuf), errorbuf);
			if( IsPGPError (ex) )
				printf("\n\nError: %d \"%s\"\n",ex, errorbuf);
		}

// Clean up - Dealocate all refs
	if( PGPKeyIterRefIsValid( theIterator)) 	PGPFreeKeyIter(theIterator );
	if( PGPKeyListRefIsValid( theKeyListRef))	PGPFreeKeyList(theKeyListRef );
	if( PGPKeySetRefIsValid ( theKeySetRef ))	PGPFreeKeySet (theKeySetRef );
	if( PGPFileSpecRefIsValid( theFileSpec)) 	PGPFreeFileSpec(theFileSpec );
	if( PGPContextRefIsValid( theContextRef)) 	PGPFreeContext(theContextRef );

	return;

usage:
	printf("Usage: DumpKeyRing [-k keyring file] [-a ascii armored keyblock file] [-s] [-d]\n");
	}

//------------------------------------------------------------------------------------
void PrintKeyPrefInfo(PGPKeyRef theKeyRef)
//------------------------------------------------------------------------------------
{
	PGPUInt32 	theAlgorithms[16];
	PGPSize		len, count = 0;
	PGPValidity theKeyValidity;

	char*		validStr;

	const char* kAlgorithmStrings[] =  {"None","IDEA","3DES", "CAST"};


// Get Key Validity Information
	ThrowIfPGPErr( PGPGetPrimaryUserIDValidity(theKeyRef, &theKeyValidity));

		switch(theKeyValidity)
	{
		case kPGPValidity_Unknown:	validStr = "Unknown";  break;
		case kPGPValidity_Invalid:	validStr = "Invalid";  break;
		case kPGPValidity_Marginal:	validStr = "Marginal"; break;
		case kPGPValidity_Complete:	validStr = "Complete"; break;
		default:					validStr = "Untrusted"; break;
	}
	printf("\t     Key validity is %s",validStr);

// Get Prefered Algorithms
	printf("\tPreferred Algorithms: ");

	ThrowIfPGPErr( PGPGetKeyPropertyBuffer(	theKeyRef,
		kPGPKeyPropPreferredAlgorithms,
		sizeof (theAlgorithms),
		(PGPByte*) &theAlgorithms, &len));


	if(len >= sizeof(PGPCipherAlgorithm))
	{
		int i;
		count = len / sizeof(PGPCipherAlgorithm);
		for(i =0; i < count; i++)
			if((theAlgorithms[i] >= kPGPCipherAlgorithm_None)
				&& (theAlgorithms[i] <= kPGPCipherAlgorithm_CAST5))
					printf("%s ", kAlgorithmStrings[theAlgorithms[i]]);
			else
				printf("Unknown ");
	}
	else
		printf("-None Set-");

	printf("\n");

}

//------------------------------------------------------------------------------------
void PrintPrimaryKeyInfo(PGPKeyRef theKeyRef)
//------------------------------------------------------------------------------------
{
	PGPInt32	algorithm;
	PGPBoolean	secretKey, expired, revoked, disabled, axiomatic;
	PGPInt32 	keySize;
	PGPTime		creation, expiration;
	PGPUInt16 	year, month,day;

	char  		theFingerPrintStr[255];
	char*		algStr;


// Print keyID string
	{
	PGPKeyIDRef theKeyIDRef	 = kInvalidPGPKeyIDRef;
	char* keyIDString = NULL;

 	PGPNewKeyIDFromKey(theKeyRef, &theKeyIDRef);
	PGPGetKeyIDString(theKeyIDRef, kPGPKeyIDString_Abbreviated, &keyIDString);
	printf("\t     Key ID: %s", keyIDString);

	if(keyIDString) PGPFreeData (keyIDString);
	if( PGPKeyIDRefIsValid( theKeyIDRef)) 	PGPFreeKeyID(theKeyIDRef);
	}

	ThrowIfPGPErr( PGPGetKeyNumber (theKeyRef, kPGPKeyPropAlgID, &algorithm));
	ThrowIfPGPErr( PGPGetKeyBoolean(theKeyRef, kPGPKeyPropIsSecret,	&secretKey));
	ThrowIfPGPErr( PGPGetKeyBoolean(theKeyRef, kPGPKeyPropIsExpired, &expired));
	ThrowIfPGPErr( PGPGetKeyBoolean(theKeyRef, kPGPKeyPropIsRevoked, &revoked));
	ThrowIfPGPErr( PGPGetKeyBoolean(theKeyRef, kPGPKeyPropIsDisabled, &disabled));
	ThrowIfPGPErr( PGPGetKeyBoolean(theKeyRef, kPGPKeyPropIsAxiomatic, &axiomatic));

	ThrowIfPGPErr( PGPGetKeyTime(theKeyRef, kPGPKeyPropExpiration, &expiration));
	ThrowIfPGPErr( PGPGetKeyTime(theKeyRef, kPGPKeyPropCreation, &creation));
	ThrowIfPGPErr( PGPGetKeyNumber(theKeyRef, kPGPKeyPropBits, &keySize));


// Get key Information
	switch(algorithm)
	{
		case kPGPPublicKeyAlgorithm_Invalid:		algStr = "Invalid";  break;
		case kPGPPublicKeyAlgorithm_RSA:			algStr = "RSA"; 	break;
		case kPGPPublicKeyAlgorithm_RSAEncryptOnly:	algStr = "RSA-EncryptOnly"; break;
		case kPGPPublicKeyAlgorithm_RSASignOnly:	algStr = "RSA-SignOnly"; 	break;
		case kPGPPublicKeyAlgorithm_ElGamal: 		algStr = "DH"; 		break;
		case kPGPPublicKeyAlgorithm_DSA: 			algStr = "DSA"; 	break;
		default:									algStr = "Unknown";	break;
	}

	printf(" %s %s (%d", algStr,  ((secretKey) ? "Key Pair":"Public Key"), keySize);
	if(expired) printf(" Expired");   if(revoked) printf(" Revoked");
	if(disabled) printf(" Disabled");
	printf(" ) ");

	//print Key Timespan
	PGPGetYMDFromPGPTime( creation,&year, &month,&day);
	printf("%02d/%02d/%04d - ",month,day,year);
	if( expiration != kPGPExpirationTime_Never)
	{
		PGPGetYMDFromPGPTime( expiration,&year, &month,&day);
		printf("%02d/%02d/%04d - ",month,day,year);
	}
	else
		printf("never");
	printf("\n");

// Print Fingerprint String
	{
	char  		theFingerPrintStr[255];
	PGPByte	 	fpBuffer[ 256 ];
	PGPSize		len;

	ThrowIfPGPErr(PGPGetKeyPropertyBuffer( theKeyRef, kPGPKeyPropFingerprint, sizeof( fpBuffer ), fpBuffer, &len));
	FormatFingerprintString(theFingerPrintStr, fpBuffer, len) ;
	printf("\tFingerPrint: %s\n", theFingerPrintStr);
	}
	printf("\t------------------------------------------------------------------\n");
}




//------------------------------------------------------------------------------------
void PrintSubKeyInfo(PGPSubKeyRef theSubKeyRef)
//------------------------------------------------------------------------------------
{
	PGPInt32	algorithm;
	PGPBoolean	secretKey, expired, revoked, disabled, axiomatic;
	PGPInt32 	keySize;
	PGPTime		creation, expiration;
	PGPUInt16 	year, month,day;
	char*		algStr;

// Print keyID string
	{
	PGPKeyIDRef theKeyIDRef	 = kInvalidPGPKeyIDRef;
	char* keyIDString = NULL;

 	PGPNewKeyIDFromSubKey(theSubKeyRef, &theKeyIDRef);
	PGPGetKeyIDString(theKeyIDRef, kPGPKeyIDString_Abbreviated, &keyIDString);
	printf("\t     Key ID: %s", keyIDString);

	if(keyIDString) PGPFreeData (keyIDString);
	if( PGPKeyIDRefIsValid( theKeyIDRef)) 	PGPFreeKeyID(theKeyIDRef);
	}

	ThrowIfPGPErr( PGPGetSubKeyNumber (theSubKeyRef, kPGPKeyPropAlgID, &algorithm));
	ThrowIfPGPErr( PGPGetSubKeyBoolean(theSubKeyRef, kPGPKeyPropIsSecret, 	&secretKey));
	ThrowIfPGPErr( PGPGetSubKeyBoolean(theSubKeyRef, kPGPKeyPropIsExpired, 	&expired));
	ThrowIfPGPErr( PGPGetSubKeyBoolean(theSubKeyRef, kPGPKeyPropIsRevoked, 	&revoked));
	ThrowIfPGPErr( PGPGetSubKeyBoolean(theSubKeyRef, kPGPKeyPropIsDisabled,	&disabled));
	ThrowIfPGPErr( PGPGetSubKeyTime(theSubKeyRef, kPGPKeyPropExpiration, 	&expiration));
	ThrowIfPGPErr( PGPGetSubKeyTime(theSubKeyRef, kPGPKeyPropCreation,	&creation));
	ThrowIfPGPErr( PGPGetSubKeyNumber(theSubKeyRef, kPGPKeyPropBits,	&keySize));

// Get key Information
	switch(algorithm)
	{
		case kPGPPublicKeyAlgorithm_Invalid:		algStr = "Invalid";  break;
		case kPGPPublicKeyAlgorithm_RSA:			algStr = "RSA"; 	break;
		case kPGPPublicKeyAlgorithm_RSAEncryptOnly:	algStr = "RSA-EncryptOnly"; break;
		case kPGPPublicKeyAlgorithm_RSASignOnly:	algStr = "RSA-SignOnly"; 	break;
		case kPGPPublicKeyAlgorithm_ElGamal: 		algStr = "DH"; 		break;
		case kPGPPublicKeyAlgorithm_DSA:			algStr = "DSA"; 	break;
		default:									algStr = "Unknown";	break;
	}

	printf(" %s %s (%d", algStr,  ((secretKey) ? "Key Pair":"Public Key"), keySize);
//	printf(" %s (%d", algStr, keySize);
	if(expired) printf(" Expired");   if(revoked) printf(" Revoked");
	if(disabled) printf(" Disabled");
	printf(") ");

	//print Key Timespan
	PGPGetYMDFromPGPTime( creation,&year, &month,&day);
	printf("%02d/%02d/%04d - ",month,day,year);
	if( expiration != kPGPExpirationTime_Never)
	{
		PGPGetYMDFromPGPTime( expiration,&year, &month,&day);
		printf("%02d/%02d/%04d - ",month,day,year);
	}
	else
		printf("never");
	printf("\n");

// Print Fingerprint String
	{
	char  		theFingerPrintStr[255];
	PGPByte	 	fpBuffer[ 256 ];
	PGPSize		len;

	ThrowIfPGPErr(PGPGetSubKeyPropertyBuffer( theSubKeyRef, kPGPKeyPropFingerprint, sizeof( fpBuffer ), fpBuffer, &len));
	FormatFingerprintString(theFingerPrintStr, fpBuffer, len) ;
	printf("\tFingerPrint: %s\n", theFingerPrintStr);
	}
	printf("\t------------------------------------------------------------------\n");
}

//------------------------------------------------------------------------------------
void FormatFingerprintString(char *p, PGPByte *inBuffp, PGPSize len )
//------------------------------------------------------------------------------------
{
	static char hexDigit[] = "0123456789ABCDEF";
	int			strIndex;

	if(len == 20)
		{
			for(strIndex = 0 ; strIndex < 20 ; strIndex++)
			{
				*p++ = hexDigit[inBuffp[strIndex]>>4];
				*p++ = hexDigit[inBuffp[strIndex]&0xF];
				if((strIndex == 1) || (strIndex == 3) || (strIndex == 5)
						|| (strIndex == 7) || (strIndex == 11) ||
						(strIndex == 13)
						|| (strIndex == 13) || (strIndex == 15) ||
						(strIndex == 17))
					*p++ = ' ';
				else if(strIndex == 9)
				{
					*p++ = ' ';
					*p++ = ' ';
				}
			}
		}
	else
		{
			for(strIndex = 0 ; strIndex < 16 ; strIndex++)
			{
				*p++ = hexDigit[inBuffp[strIndex]>>4];
				*p++ = hexDigit[inBuffp[strIndex]&0xF];
				if((strIndex == 1) || (strIndex == 3) || (strIndex == 5)
					|| (strIndex == 9) || (strIndex == 11) || (strIndex == 13))
					*p++ = ' ';
				else if(strIndex == 7)
				{
					*p++ = ' ';
					*p++ = ' ';
				}
			}
		}
	*p++ = '\0';
}


                   Z   Z   Rw_array  5_%__dynamic_cast F_%EDumpKeyRing.cpp   TEXTCWIE o  TEXTCWIE oC                  {}c  Mr  ain_errorFv !_%cleanup__51basic_string_ref<c,14char_traits<c>,12allocator<c>>Fv _%__del_hdl  _%set_unexpected__FPFv_v _%__re   H 	Monaco                             -e -e{B  
  /  
                Z   Z   RQD.F    R MPSR  MWBB   *           L       R                                                                                        