/*------------------------------------------------------------------------

      File:  cmdSetenv.c
   Project:  Tcl Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.2
  Last Mod:  20:19:58, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)cmdSetenv.c	1.2\t1/19/92";

#include "global.h"

int
cmdSetEnv(ClientData client_data,
	  Tcl_Interp* interp,
	  int argc,
	  char* argv[])
{
  char* oldval;

  if(argc != 3) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " variable value\"", (char *) NULL);
    return TCL_ERROR;
  }

  /* Check to see if variable is already set correctly... */
  if((! (flags & (M_REMOVE | M_DISPLAY | M_SWITCH))) && 
     (oldval = getenv(argv[1]))) {
    if(!strcmp(argv[2], oldval)) {
      return TCL_OK;
    } else {
      fprintf(stderr, "Replacing old value of %s: '%s'\n", argv[1], oldval);
    }
  }

  if(flags & M_SWSTATE1) {
    set_backup(backup_environ_changes, argv[1], SWMARKER);
    return TCL_OK;
  }

  if(flags & M_SWSTATE2) {
    set_backup(backup_environ_changes, argv[1], argv[2]);
  }
  
  if(flags & M_SWSTATE3) {
    char* backup_val;
    backup_val = get_backup(backup_environ_changes, argv[1]);
    if(backup_val) {
      if(! strcmp(backup_val, SWMARKER))
	return cmdUnsetEnv(client_data, interp, --argc, argv);
      else
	return TCL_OK;
    }
  } else if(flags & M_REMOVE) {
    return cmdUnsetEnv(client_data, interp, --argc, argv);
  }

  setenv(argv[1], argv[2]);  /* Must use Tcl setenv */

  if(flags & M_DISPLAY) {
    fprintf(stderr, "Setenv %s to %s\n", argv[1], argv[2]);
    return 0;
  }

  set_shell_variable(argv[1], argv[2]);

  return TCL_OK;
}

int
cmdUnsetEnv(ClientData client_data,
	    Tcl_Interp* interp,
	    int argc,
	    char* argv[])
{
  if(argc != 2) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " variable\"", (char *) NULL);
    return TCL_ERROR;
  }

  if(flags & M_DISPLAY) {
    fprintf(stderr, "Unsetenv %s\n", argv[1]);
    return 0;
  }
  
  /*
    Just don't unset the variable in Tcl Space.
    If module writer *REALLY* wants it gone, use $env
  */

  unset_shell_variable(argv[1]);
  
  return TCL_OK;
}

