/*------------------------------------------------------------------------

      File:  main.c
   Project:  Tcl Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.2
  Last Mod:  20:20:00, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)main.c	1.2\t1/19/92";

#include "global.h"

/* Global Vars */
char*       current_module = 0;
char**      shell_startups;
char        shell_name[10];
char        shell_derelict[4];
int         flags = 0;

Tcl_HashTable   set_changes_env_table;
Tcl_HashTable   unset_changes_env_table;
Tcl_HashTable   backup_alias_table;
Tcl_HashTable   backup_env_table;

Tcl_HashTable*  set_environ_changes;
Tcl_HashTable*  unset_environ_changes;
Tcl_HashTable*  backup_environ_changes;
Tcl_HashTable*  backup_alias_changes;


char**      backup_envp;

int
main(int argc, char* argv[]) {
  Tcl_Interp*  interp;
  int          return_val, saved_stdout;

  Initialize_Tcl(&interp, argc, argv);
  Setup_Environment(interp);

  if(argc < 3) {
    char* helpargv[3];

    fprintf(stderr, "\nUsage:  %s shell sub-command [args]\n", argv[0]);

    helpargv[0] = "module";
    helpargv[1] = "help";
    helpargv[2] = NULL;

    cmdModule((ClientData) 0, interp, 2, helpargv);
    return 1;
  }

  if(argc > 2) {
    saved_stdout = TieStdout();
    return_val = cmdModule((ClientData) 0, interp, (argc - 1), (argv + 1));
    if(UnTieStdout(saved_stdout) != 1) {
      fprintf(stderr, "Restoring STDOUT Failed\n");
      return 1;
    }

    if(return_val == TCL_OK) {
      Flush_Shell_Changes();
      return 0;
    } else {
      if(*interp->result)
	if(current_module)
	  fprintf(stderr, "\nERROR with modulefile '%s':\n\t%s\n", 
		  current_module, interp->result);
	else
	  fprintf(stderr, "\nERROR:  %s\n", interp->result);

      fprintf(stderr, "\nAn error occured while processing your module \
command -- No Changes Were Made\n\n");
      return 1;
    }
  }
}
