/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.transport;

import java.util.LinkedList;
import java.util.List;
import org.gnunet.hello.HelloMessage;
import org.gnunet.mq.Envelope;
import org.gnunet.mq.NotifySentHandler;
import org.gnunet.transport.HelloUpdateCallback;
import org.gnunet.transport.OfferHelloContinuation;
import org.gnunet.transport.TryConnectCallback;
import org.gnunet.transport.messages.RequestConnectMessage;
import org.gnunet.transport.messages.StartMessage;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transport {
    private static final Logger logger = LoggerFactory.getLogger(Transport.class);
    private final Client client;
    private HelloMessage myHello;
    private List<GetHelloHolder> getHelloHolderList = new LinkedList<GetHelloHolder>();

    private void sendStart() {
        StartMessage m = new StartMessage();
        m.options = 0;
        m.self = new PeerIdentity();
        this.client.send(m);
    }

    public Transport(Configuration cfg) {
        this.client = new Client("transport", cfg);
        this.client.installReceiver(new TransportReceiver());
        this.sendStart();
    }

    Cancelable tryConnect(PeerIdentity target, final TryConnectCallback cb) {
        RequestConnectMessage m = new RequestConnectMessage();
        m.peer = target;
        m.reserved = 0;
        final Envelope ev = new Envelope(m);
        ev.notifySent(new NotifySentHandler(){

            @Override
            public void onSent() {
                cb.onDone();
            }
        });
        this.client.send(ev);
        return new Cancelable(){

            @Override
            public void cancel() {
                ev.cancel();
            }
        };
    }

    Cancelable getHello(final HelloUpdateCallback rec) {
        if (this.myHello != null) {
            return Scheduler.add(new Scheduler.Task(){

                @Override
                public void run(Scheduler.RunContext ctx) {
                    rec.onHello(Transport.this.myHello);
                }
            });
        }
        System.out.println("waiting for hello");
        final GetHelloHolder holder = new GetHelloHolder();
        holder.cb = rec;
        this.getHelloHolderList.add(holder);
        return new Cancelable(){

            @Override
            public void cancel() {
                Transport.this.getHelloHolderList.remove(holder);
            }
        };
    }

    Cancelable offerHello(HelloMessage hello, final OfferHelloContinuation cont) {
        final Envelope ev = new Envelope(hello);
        ev.notifySent(new NotifySentHandler(){

            @Override
            public void onSent() {
                cont.onDone();
            }
        });
        this.client.send(ev);
        return new Cancelable(){

            @Override
            public void cancel() {
                ev.cancel();
            }
        };
    }

    public void disconnect() {
        this.client.disconnect();
    }

    private final class TransportReceiver
    extends RunaboutMessageReceiver {
        private TransportReceiver() {
        }

        public void visit(HelloMessage m) {
            System.out.println("got hello");
            Transport.this.myHello = m;
            List list = Transport.this.getHelloHolderList;
            Transport.this.getHelloHolderList = new LinkedList();
            for (GetHelloHolder h : list) {
                h.cb.onHello(m);
            }
        }

        @Override
        public void handleError() {
            logger.warn("Error receiving from the transport service, reconnecting.");
            Transport.this.client.reconnect();
            Transport.this.sendStart();
        }
    }

    private class GetHelloHolder {
        HelloUpdateCallback cb;

        private GetHelloHolder() {
        }
    }
}

