/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import org.gnunet.identity.Identity;
import org.gnunet.identity.IdentityCallback;
import org.gnunet.mesh.ChannelEndHandler;
import org.gnunet.mesh.Mesh;
import org.gnunet.mesh.MeshRunabout;
import org.gnunet.secretsharing.ThresholdPublicKey;
import org.gnunet.testbed.CompressedConfig;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Configuration;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.Program;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.Scheduler;
import org.gnunet.util.getopt.Argument;
import org.gnunet.util.getopt.ArgumentAction;
import org.gnunet.voting.Ballot;
import org.gnunet.voting.GroupCert;
import org.gnunet.voting.InvalidBallotException;
import org.gnunet.voting.messages.BallotRegisterFailureMessage;
import org.gnunet.voting.messages.BallotRegisterRequestMessage;
import org.gnunet.voting.messages.BallotRegisterSuccessMessage;
import org.gnunet.voting.messages.KeyQueryFailureMessage;
import org.gnunet.voting.messages.KeyQueryMessage;
import org.gnunet.voting.messages.KeyQueryResponseMessage;
import org.gnunet.voting.messages.ResultQueryFailureMessage;
import org.gnunet.voting.messages.ResultQueryMessage;
import org.gnunet.voting.messages.ResultQueryResponseMessage;
import org.gnunet.voting.messages.SubmitFailureMessage;
import org.gnunet.voting.messages.SubmitMessage;
import org.gnunet.voting.messages.SubmitSuccessMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallotTool
extends Program {
    private static final Logger logger = LoggerFactory.getLogger(BallotTool.class);
    @Argument(shortname="e", longname="ego", action=ArgumentAction.STORE_STRING, description="ego to use for the operation")
    String egoName = null;
    @Argument(shortname="q", longname="query", action=ArgumentAction.SET, description="query election result")
    boolean query = false;
    @Argument(shortname="s", longname="submit", action=ArgumentAction.SET, description="submit the vote to the authorities")
    boolean submit = false;
    @Argument(shortname="r", longname="register", action=ArgumentAction.SET, description="register an election with the authorities")
    boolean register = false;
    @Argument(shortname="i", longname="issue", action=ArgumentAction.SET, description="sign the ballot as issuer (use with -e)")
    boolean issue = false;
    @Argument(shortname="x", longname="select", action=ArgumentAction.STORE_STRING, argumentName="CHOICE", description="select and encrypt a vote option (use with -e)")
    String select = null;
    @Argument(shortname="V", longname="verify", action=ArgumentAction.SET, description="verify signatures in the ballot and show information")
    boolean verify = false;
    @Argument(shortname="g", longname="group", action=ArgumentAction.STORE_STRING, description="incorporate the group cert into the ballot")
    String groupCertFile = null;
    @Argument(shortname="k", longname="getRequestIdentifier-key", action=ArgumentAction.SET, description="getRequestIdentifier the threshold public key from authorities")
    boolean requestKey = false;
    @Argument(shortname="t", longname="template", action=ArgumentAction.SET, description="write a template ballot to the give ballot file")
    boolean template = false;
    private Identity.Ego ego;
    private Ballot ballot;
    private String ballotFilename;
    private Mesh mesh;
    private Mesh.Channel channel;
    private PeerIdentity currentAuthority;
    private boolean tunnelCommunicationFinished;
    private RelativeTime tunnelReconnectBackoff = RelativeTime.STD_BACKOFF;

    private void endMesh() {
        this.tunnelCommunicationFinished = true;
        if (null != this.channel) {
            this.channel.destroy();
            this.channel = null;
        }
        if (null != this.mesh) {
            this.mesh.destroy();
            this.mesh = null;
        }
    }

    @Override
    protected String makeHelpText() {
        return "gnunet-ballot [OPTIONS]... BALLOT\nCreate, modify and execute operation on ballots.";
    }

    private void runTemplate() {
        File f = new File(this.ballotFilename);
        if (f.exists()) {
            System.err.println("file already exists, not overwriting");
            return;
        }
        InputStream is = this.getClass().getResourceAsStream("ballot-template.espec");
        ByteSink out = Files.asByteSink((File)f, (FileWriteMode[])new FileWriteMode[0]);
        try {
            out.writeFrom(is);
        }
        catch (IOException e) {
            System.err.println("could not copy template file: " + e.getMessage());
        }
    }

    private void writeBallot() {
        try {
            Files.write((CharSequence)this.ballot.serialize(), (File)new File(this.ballotFilename), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println("could not write ballot file: " + e.getMessage());
        }
    }

    void doCommands() {
        if (null != this.groupCertFile) {
            Configuration groupCertConfig = new Configuration();
            groupCertConfig.parse(this.groupCertFile);
            GroupCert groupCert = GroupCert.fromGroupCertConfig(groupCertConfig);
            this.ballot.encodeGroup(groupCert);
            this.writeBallot();
            return;
        }
        if (this.register) {
            List<PeerIdentity> remainingAuthorities = this.ballot.getRemainingRegisterAuthorities();
            if (remainingAuthorities.isEmpty()) {
                System.err.println("all authorities already received the ballot");
                return;
            }
            Random r = new Random();
            this.currentAuthority = remainingAuthorities.get(r.nextInt(remainingAuthorities.size()));
            System.out.println("registering ballot with authority " + this.currentAuthority.toString());
            this.mesh = new Mesh(this.getConfiguration(), new BallotChannelEndHandler(), new BallotRegisterReceiver());
            this.channel = this.mesh.createChannel(this.currentAuthority, 1002, true, true);
            BallotRegisterRequestMessage m = new BallotRegisterRequestMessage();
            CompressedConfig ccfg = new CompressedConfig(this.ballot.toConfiguration());
            m.compressedBallotConfig = ccfg.compressedData;
            this.channel.send(m);
            return;
        }
        if (this.issue) {
            if (null == this.ego) {
                System.err.println("no ego given");
                this.setReturnValue(1);
                return;
            }
            this.ballot.issue(this.ego.getPrivateKey());
            this.writeBallot();
            return;
        }
        if (this.select != null) {
            if (null == this.ego) {
                System.err.println("no ego given");
                this.setReturnValue(1);
                return;
            }
            ThresholdPublicKey thresholdPublicKey = this.ballot.getMajorityThresholdPublicKey();
            if (null == thresholdPublicKey) {
                System.err.println(String.format("no majority threshold public key in ballot (got keys of %s authorities)", this.ballot.thresholdPublicKeys == null ? 0 : this.ballot.thresholdPublicKeys.size()));
                this.setReturnValue(1);
                return;
            }
            this.ballot.encodeChoice(this.select, thresholdPublicKey, this.ego.getPrivateKey());
            this.writeBallot();
            return;
        }
        if (this.submit) {
            List<PeerIdentity> remainingAuthorities = this.ballot.getRemainingSubmitAuthorities();
            if (remainingAuthorities.isEmpty()) {
                System.err.println("all authorities already received the ballot");
                return;
            }
            Random r = new Random();
            PeerIdentity authority = remainingAuthorities.get(r.nextInt(remainingAuthorities.size()));
            System.out.println("submitting to authority " + authority.toString());
            this.currentAuthority = authority;
            this.mesh = new Mesh(this.cfg, new BallotChannelEndHandler(), new SubmitReceiver());
            this.channel = this.mesh.createChannel(authority, 1002, true, true);
            SubmitMessage m = new SubmitMessage();
            if (this.ballot.voterPub == null) {
                throw new InvalidBallotException("no voter in ballot");
            }
            m.voterPub = this.ballot.voterPub;
            if (this.ballot.groupCert == null) {
                throw new InvalidBallotException("no group cert in ballot");
            }
            m.groupCertExpiration = this.ballot.groupCert.getExpiration().asMessage();
            m.groupCert = this.ballot.groupCert.getSignature();
            m.ballotGuid = this.ballot.getBallotGuid();
            if (null == this.ballot.encryptedVote) {
                throw new InvalidBallotException("no encrypted vote in ballot");
            }
            m.encryptedVote = this.ballot.encryptedVote;
            this.channel.send(m);
            return;
        }
        if (this.verify) {
            System.out.print(this.ballot.describe());
            return;
        }
        if (this.query) {
            List<PeerIdentity> remainingAuthorities = this.ballot.getAuthorities();
            if (remainingAuthorities.isEmpty()) {
                System.err.println("no authorities available");
                this.setReturnValue(2);
                return;
            }
            Random r = new Random();
            this.currentAuthority = remainingAuthorities.get(r.nextInt(remainingAuthorities.size()));
            System.out.println("querying authority " + this.currentAuthority.toString());
            this.mesh = new Mesh(this.cfg, new BallotChannelEndHandler(), new QueryReceiver());
            this.channel = this.mesh.createChannel(this.currentAuthority, 1002, true, true);
            ResultQueryMessage m = new ResultQueryMessage();
            m.ballotGuid = this.ballot.getBallotGuid();
            this.channel.send(m);
            return;
        }
        if (this.requestKey) {
            List<PeerIdentity> remainingAuthorities = this.ballot.getRemainingKeyAuthorities();
            if (remainingAuthorities.isEmpty()) {
                System.err.println("all authorities already signed group key");
                return;
            }
            Random r = new Random();
            this.currentAuthority = remainingAuthorities.get(r.nextInt(remainingAuthorities.size()));
            System.out.println("asking authority for key " + this.currentAuthority.toString());
            this.mesh = new Mesh(this.cfg, new BallotChannelEndHandler(), new PublicKeyReceiver());
            this.channel = this.mesh.createChannel(this.currentAuthority, 1002, true, true);
            KeyQueryMessage m = new KeyQueryMessage();
            m.ballotGuid = this.ballot.getBallotGuid();
            this.channel.send(m);
            return;
        }
        this.setReturnValue(1);
        System.err.println("no action specified");
    }

    @Override
    public void run() {
        if (this.unprocessedArgs.length != 1) {
            System.err.println("no ballot file specified");
            this.setReturnValue(1);
            return;
        }
        this.ballotFilename = this.unprocessedArgs[0];
        if (this.template) {
            this.runTemplate();
            return;
        }
        File bf = new File(this.ballotFilename);
        if (!bf.exists()) {
            System.err.println("ballot file does not exist");
            return;
        }
        try {
            this.ballot = new Ballot(this.ballotFilename);
        }
        catch (InvalidBallotException e) {
            System.err.println("Invalid or incomplete ballot:");
            System.err.println(e.getMessage());
            this.setReturnValue(1);
            return;
        }
        if (null != this.egoName) {
            Identity.lookup(this.getConfiguration(), this.egoName, new IdentityCallback(){

                @Override
                public void onEgo(Identity.Ego ego) {
                    BallotTool.this.ego = ego;
                    BallotTool.this.doCommands();
                }

                @Override
                public void onError(String errorMessage) {
                    System.err.println("can't retrieve ego: " + errorMessage);
                    BallotTool.this.setReturnValue(1);
                }
            });
        } else {
            this.doCommands();
        }
    }

    public static void main(String[] args) {
        BallotTool tool = new BallotTool();
        int ret = tool.start(args);
        System.exit(ret);
    }

    public class SubmitReceiver
    extends MeshRunabout {
        public void visit(SubmitSuccessMessage m) {
            System.out.println("vote successfully submitted");
            BallotTool.this.ballot.addConfirmation(BallotTool.this.currentAuthority, m.confirmationSig);
            BallotTool.this.writeBallot();
            BallotTool.this.endMesh();
        }

        public void visit(SubmitFailureMessage m) {
            System.out.println("vote not submitted: " + m.reason);
            if (m.signedAuthorityTime != null) {
                System.out.println("authority time: " + AbsoluteTime.fromNetwork(m.signedAuthorityTime.time).toFancyString());
            }
            BallotTool.this.endMesh();
            BallotTool.this.setReturnValue(1);
        }
    }

    public class PublicKeyReceiver
    extends MeshRunabout {
        public void visit(KeyQueryResponseMessage m) {
            System.out.println("got threshold public key!");
            BallotTool.this.ballot.addThresholdPublicKey(BallotTool.this.currentAuthority, m);
            BallotTool.this.writeBallot();
            BallotTool.this.endMesh();
        }

        public void visit(KeyQueryFailureMessage m) {
            System.out.println("failure to query result: " + m.reason);
            BallotTool.this.endMesh();
            BallotTool.this.setReturnValue(1);
        }
    }

    public class QueryReceiver
    extends MeshRunabout {
        public void visit(ResultQueryResponseMessage m) {
            if (m.results.length != ((BallotTool)BallotTool.this).ballot.choices.size()) {
                System.out.println("failure to query result: malformed response");
            } else {
                System.out.println("got results:");
                for (int i = 0; i < m.results.length; ++i) {
                    System.out.println("'" + ((BallotTool)BallotTool.this).ballot.choices.get(i) + "': " + m.results[i]);
                }
            }
            BallotTool.this.endMesh();
        }

        public void visit(ResultQueryFailureMessage m) {
            System.out.println("failure to query result: " + m.reason);
            BallotTool.this.endMesh();
            BallotTool.this.setReturnValue(1);
        }
    }

    public class BallotRegisterReceiver
    extends MeshRunabout {
        public void visit(BallotRegisterSuccessMessage m) {
            System.out.println("ballot successfully registered");
            BallotTool.this.ballot.addRegistrationSignature(BallotTool.this.currentAuthority, m.registrationSignature);
            BallotTool.this.writeBallot();
            BallotTool.this.endMesh();
        }

        public void visit(BallotRegisterFailureMessage m) {
            System.out.println("registering failed: " + m.reason);
            BallotTool.this.endMesh();
            BallotTool.this.setReturnValue(1);
        }
    }

    public class BallotChannelEndHandler
    implements ChannelEndHandler {
        @Override
        public void onChannelEnd(Mesh.Channel channel) {
            BallotTool.this.channel = null;
            if (!BallotTool.this.tunnelCommunicationFinished) {
                logger.warn("mesh channel disconnected, but operation not finished");
                Scheduler.addDelayed(BallotTool.this.tunnelReconnectBackoff, new Scheduler.Task(){

                    @Override
                    public void run(Scheduler.RunContext ctx) {
                        BallotTool.this.doCommands();
                    }
                });
                BallotTool.this.tunnelReconnectBackoff = BallotTool.this.tunnelReconnectBackoff.backoff();
            }
        }
    }
}

