/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include "bstmenus.h"



/* --- prototypes --- */
static GtkMenuFactory*	bst_menus_get_subfactory	(GtkMenuFactory	*factory,
							 const gchar	*path);
static gint		bst_menus_install_accelerator	(GtkWidget	*widget,
							 const gchar	*signal_name,
							 gchar		 key,
							 guint8		 modifiers,
							 gpointer	 user_data);
static void		bst_menus_remove_accelerator	(GtkWidget	*widget,
							 const gchar	*signal_name,
							 gpointer	 user_data);
static void		bst_menus_pattern_menu_callback (GtkWidget	*item,
							 gpointer	 func_data);
static GtkWidget*	bst_menus_adjust_pattern_menu	(void);


/* --- static variables --- */
static GtkMenuFactory	*bst_factory = NULL;
static GHashTable	*bst_factory_ht = NULL;
static GtkMenuEntry	menu_items[] = {
  /* pattern menu
   */
  { "<pattern-menu>/Pattern Menu", NULL, NULL, NULL, NULL },
  { "<pattern-menu>/<separator>", NULL, NULL, NULL, NULL },
  //  { "<pattern-menu>/Open View...", "<control>V", bst_menus_pattern_menu_callback, (gpointer) BST_PLA_OPEN_VIEW, NULL },
};
static guint	n_menu_items = sizeof (menu_items) / sizeof (menu_items[0]);
static BstSongShell	*bst_fg_song_shell = NULL;


/* --- functions --- */
GtkMenuFactory*
bst_menus_create (void)
{
  if (!bst_factory)
    {
      GtkMenuFactory *subfactory;
      
      bst_factory = gtk_menu_factory_new (GTK_MENU_FACTORY_MENU_BAR);
      bst_factory_ht = NULL;
      
      subfactory = gtk_menu_factory_new (GTK_MENU_FACTORY_MENU);
      gtk_menu_factory_add_subfactory (bst_factory, subfactory, "<pattern-menu>");
      
      /* FIXME: need menurc parsing here
       */
      
      bst_menus_add_items (menu_items, n_menu_items);
    }
  
  return bst_factory;
}

void
bst_menus_shutdown (void)
{
  g_return_if_fail (bst_factory != NULL);

  /* FIXME save accelerator table here
   */
  bst_factory_ht = NULL;

  gtk_menu_factory_destroy (bst_factory);

  bst_factory = NULL;
}

void
bst_menus_set_fg_song_shell (BstSongShell   *song_shell)
{
  if (bst_fg_song_shell != song_shell)
    {
      static guint fg_h_id = 0;

      if (bst_fg_song_shell)
	{
	  gtk_signal_disconnect (GTK_OBJECT (bst_fg_song_shell), fg_h_id);
	  fg_h_id = 0;
	  bst_fg_song_shell = NULL;
	}

      if (song_shell)
	{
	  g_return_if_fail (BST_IS_SONG_SHELL (song_shell));

	  fg_h_id = gtk_signal_connect_object (GTK_OBJECT (song_shell),
					       "destroy",
					       GTK_SIGNAL_FUNC (bst_menus_set_fg_song_shell),
					       NULL);
	  
	  bst_fg_song_shell = song_shell;
	}
    }
}

BstSongShell*
bst_menus_get_fg_song_shell (void)
{
  return bst_fg_song_shell;
}

static GtkMenuFactory*
bst_menus_get_subfactory (GtkMenuFactory *factory,
			  const gchar *path)
{
  GList *list;

  g_return_val_if_fail (factory != NULL, NULL);

  if (factory->path && g_str_equal (factory->path, (gpointer) path))
    return factory;

  for (list = factory->subfactories; list; list = list->next)
    {
      factory = bst_menus_get_subfactory (list->data, path);
      if (factory)
	return factory;
    }

  return NULL;
}

void
bst_menus_adjust_item (const gchar    *item_path,
		       gboolean	       sensitive,
		       gpointer	       user_data)
{
  GtkMenuPath *menu_path;

  g_return_if_fail (item_path != NULL);

  if (!bst_factory)
    bst_menus_create ();

  menu_path = gtk_menu_factory_find (bst_factory, item_path);
  g_return_if_fail (menu_path != NULL);

  gtk_widget_set_sensitive (menu_path->widget, sensitive);
  gtk_object_set_user_data (GTK_OBJECT (menu_path->widget), user_data);
}

GtkAcceleratorTable*
bst_menus_pattern_menu_table (void)
{
  GtkMenuFactory *factory;

  if (!bst_factory)
    bst_menus_create ();

  factory = bst_menus_get_subfactory (bst_factory, "<pattern-menu>");

  if (factory)
    return factory->table;
  else
    return NULL;
}

static gint
bst_menus_install_accelerator (GtkWidget      *widget,
			       const gchar    *signal_name,
			       gchar	       key,
			       guint8	       modifiers,
			       gpointer	       user_data)
{
  return TRUE;
}

static void
bst_menus_remove_accelerator (GtkWidget	     *widget,
			      const gchar    *signal_name,
			      gpointer	      user_data)
{
}

void
bst_menus_add_items (GtkMenuEntry *items,
		     guint	   n_items)
{
  guint i;

  if (n_items == 0)
    return;
  g_return_if_fail (items != NULL);

  if (!bst_factory)
    bst_menus_create ();

  for (i = 0; i < n_items; i++)
    {
      gchar *accelerator;
      
      g_assert (items[i].widget == NULL);
      
      accelerator = g_hash_table_lookup (bst_factory_ht, items[i].path);
      if (accelerator)
	{
	  if (accelerator[0] == '\0')
	    items[i].accelerator = NULL;
	  else
	    items[i].accelerator = accelerator;
	}
    }

  gtk_menu_factory_add_entries (bst_factory, items, n_items);

  for (i = 0; i < n_items; i++)
    if (items[i].widget)
      {
	gtk_widget_set_sensitive (items[i].widget, FALSE);
	
	gtk_signal_connect (GTK_OBJECT (items[i].widget),
			    "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed),
			    &items[i].widget);

	if (GTK_BIN (items[i].widget)->child)
	  {
	    gtk_signal_connect (GTK_OBJECT (items[i].widget),
				"install_accelerator",
				GTK_SIGNAL_FUNC (bst_menus_install_accelerator),
				items[i].path);
	    gtk_signal_connect (GTK_OBJECT (items[i].widget),
				"remove_accelerator",
				GTK_SIGNAL_FUNC (bst_menus_remove_accelerator),
				items[i].path);
	  }
      }
}

void
bst_menus_popup_pattern_menu (guint	      x,
			      guint	      y,
			      guint	      mouse_button,
			      guint32	      time)
{
  GtkWidget *menu;

  if (!bst_fg_song_shell)
    return;
  g_return_if_fail (BST_IS_SONG_SHELL (bst_fg_song_shell));

  if (!bst_factory)
    bst_menus_create ();

  menu = bst_menus_adjust_pattern_menu ();

  gtk_menu_popup (GTK_MENU (menu),
		  NULL, NULL,
		  NULL, NULL,
		  mouse_button, time);
}

static GtkWidget*
bst_menus_adjust_pattern_menu (void)
{
  GtkMenuFactory *factory;

  factory = bst_menus_get_subfactory (bst_factory, "<pattern-menu>");

  if (!factory || !factory->widget)
    return NULL;

  bst_menus_adjust_item ("<pattern-menu>/Open View...",
			 TRUE,
			 NULL);
  
  return factory->widget;
}

static void
bst_menus_pattern_menu_callback (GtkWidget  *item,
				 gpointer    func_data)
{
  guint action;

  g_return_if_fail (bst_fg_song_shell != NULL);
  g_return_if_fail (BST_IS_SONG_SHELL (bst_fg_song_shell));
  action = (guint) func_data;
  //  g_return_if_fail (action > BST_PLA_NONE);
  // g_return_if_fail (action < BST_PLA_LAST);

  // bst_song_shell_pla_do (bst_fg_song_shell, action);
}
