/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	"bsebase.h"
#include	"bseconfig.h"
#include	"bsemixer.h"
#include        "bseutils.h"
#include        "bseinstrument.h"
#include        "bsepattern.h"
#include        "bsesample.h"
#include        "bsesequencer.h"
#include        "bsesong.h"
#include	"bsemem.h"
#include	"bsevalueblock.h"
#include	<math.h>


/* --- defines --- */
#define	BSE_2_TPO_1_DIV_12_d	( /* 2^(1/12) */ \
  (gdouble) (1.0594630943592953098431053149397484958171844482421875))


/* --- extern variables --- */
const guint	bse_version_major = LIBBSE_MAJOR;
const guint	bse_version_revision = LIBBSE_REVISION;
const guint	bse_version_age = LIBBSE_AGE;
const gchar	*bse_version = LIBBSE_VERSION;
const guint	bse_bsw_version_major = LIBBSE_BSW_MAJOR;
const guint	bse_bsw_version_age = LIBBSE_BSW_AGE;
const gchar	*bse_bsw_version = LIBBSE_BSW_VERSION;
guint		bse_default_bpm = BSE_INIT_DFL_BPM;
gdouble		ht_factor_table_d[BSE_MAX_NOTE] = { 0.0 };
guint		ht_factor_table_fixed_ui[BSE_MAX_NOTE] = { 0 };
const gdouble	*bse_halftone_factor_table = ht_factor_table_d;
const guint	*bse_halftone_factor_table_fixed = ht_factor_table_fixed_ui;


/* --- variables --- */
static gboolean bse_is_initialized = FALSE;
static BseSample *zero_sample = NULL;


/* --- Mem Chunk Declarations --- */
#undef	GMEMCHUNK_HELPER_ITERATOR
#define GMEMCHUNK_HELPER_ITERATOR	GMEMCHUNK_HELPER_DECLARE
BSE_MEM_CHUNK_LIST();
#undef	GMEMCHUNK_HELPER_ITERATOR


/* --- functions --- */
void
bse_init (int	  *argc,
	  char	***argv)
{
  register gint i;

  g_return_if_fail (bse_is_initialized == FALSE);
  bse_is_initialized = TRUE;

  /* setup half tone factorization table
   */
  for (i = 0; i < BSE_MAX_NOTE; i++)
  {
    ht_factor_table_d[i] = pow (BSE_2_TPO_1_DIV_12_d, i - BSE_KAMMER_NOTE);
    ht_factor_table_fixed_ui[i] = ht_factor_table_d[i] * 65536;

    /* if (i > 60 && i < 75)
     *   printf ("table: [%d] -> %f\n", i, bse_ht_factor_table[i]);
     */
  }

  /* initialize & allocate mem chunks
   */
#undef	GMEMCHUNK_HELPER_ITERATOR
#define GMEMCHUNK_HELPER_ITERATOR	GMEMCHUNK_HELPER_INIT
  BSE_MEM_CHUNK_LIST();
#undef	GMEMCHUNK_HELPER_ITERATOR

  /* mixer setup
   */
  bse_mixer_set_n_values (BSE_DFL_N_MIXER_VALUES);

  /* Gtk object system setup
   */
  gtk_debug_flags |= GTK_DEBUG_OBJECTS;
  gtk_type_init ();
  gtk_signal_init ();
}

guint
bse_get_obuffer_size (void)
{
  return bse_mixer_get_n_buffer_values () * sizeof (BseSampleValue);
}

gboolean
bse_initialized (void)
{
  return bse_is_initialized;
}

static void
zero_out (gpointer d)
{
  gpointer *p = d;

  *p = NULL;
}

BseSample*
bse_get_zero_sample (void)
{
  if (!zero_sample)
    {
      zero_sample = bse_sample_new (BSE_SAMPLE_NOTE_MUNKS, "Zero-BseSample", NULL);
      bse_sample_set_params (zero_sample, 1, 22050);
      bse_sample_set_munk (zero_sample,
			   0, BSE_KAMMER_NOTE,
			   bse_value_block_zero (BSE_MAX_CHANNELS),
			   0, BSE_MAX_CHANNELS,
			   0, 0);
      bse_sample_fillup_munks (zero_sample);
      gtk_object_weakref (GTK_OBJECT (zero_sample), zero_out, &zero_sample);
    }
  else
    bse_sample_ref (zero_sample);

  return zero_sample;
}
