/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	"bseio.h"
#include	"bsesong.h"
#include	"bsesample.h"


/* --- functions --- */
BseIoData*
bse_io_data_new (BseIoDataFlags   io_flags)
{
  BseIoData *io_data;

  io_data = g_new (BseIoData, 1);

  io_data->io_flags = io_flags & BSE_IO_DATA_MASK;
  io_data->error = BSE_ERROR_NONE;
  io_data->songs = NULL;
  io_data->samples = NULL;

  return io_data;
}

void
bse_io_data_destroy (BseIoData       *io_data)
{
  GList *list;
  
  g_return_if_fail (io_data != NULL);

  for (list = io_data->songs; list; list = list->next)
    bse_song_unref (list->data);
  g_list_free (io_data->songs);

  for (list = io_data->samples; list; list = list->next)
    bse_sample_unref (list->data);
  g_list_free (io_data->samples);

  g_dataset_destroy (io_data);	/* paranoid */

  g_free (io_data);
}
