/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_IO_LOAD_H__
#define __BSE_IO_LOAD_H__

#include	<bse/bsebase.h>
#include	<bse/bseio.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



BseIoData*	bse_io_load_auto	(const gchar	*file_name,
					 BseIoDataFlags	 loader_flags);
BseIoData*	bse_io_load_auto_perc	(const gchar	 *file_name,
					 BseIoDataFlags   loader_flags,
					 BsePercentageCB  callback,
					 gpointer	  callback_data);



#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_IO_LOAD_H__ */
