#!/bin/sh
# listplugins.sh - create an automake conformant list to build plugins
# Copyright (C) 1998, 1999 Olaf Hoehmann and Tim Janik

test -z "$1" && {
	echo "$0: No input files"
	exit 1
}

echo "## Generated data (by $0)"

plugins=
last=
for file in `echo $@ | sort | uniq` ; do
	name="`echo $file | sed 's/.c$//'`"
	_name=`echo $name | sed 's/[^A-Za-z0-9]/_/g'`
	cfile="$name.c"
	hfile="$name.h"

	test -e "$cfile" || {
		echo "$cfile: No such file" >&2
		exit 1
	}

	grep -F BSE_EXPORTS_BEGIN $cfile >/dev/null || {
		echo "$cfile: missing BSE_EXPORTS_BEGIN (); directive" >&2
		exit 1
	}
	grep -F BSE_EXPORTS_END $cfile >/dev/null || {
		echo "$cfile: missing BSE_EXPORTS_END; directive" >&2
		exit 1
	}

	echo
	echo "##"
	echo "## Plugin $name"
	echo "##"
	echo "$_name""_la_SOURCES = $cfile"
	echo "$_name""_la_LDFLAGS = -module -avoid-version"
	echo "$_name""_la_LIBADD  =" '$(plugin_libs)'
	test -r "$hfile" && {
		echo "EXTRA_HEADERS += $hfile"
	}
	
	last="$name.la"
	plugins="$plugins $last"
done

echo
echo "## autogenerated plugins:"
echo "plugin_LTLIBRARIES += \\"
for p in $plugins ; do
	if test "$p" \!= "$last" ; then
		echo "	$p \\"
	else
		echo "	$p"
	fi
done
echo
echo "## Generated data ends here"

# alles wird gut! ;)

exit 0
