/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <csl/csl.h>

#include <stdio.h>
#include <string.h>
#include <errno.h>

/* this is how to do it: */

int
main (int   argc,
      char *argv[])
{
  CslErrorType error;
  CslDriver *driver;
  CslPcmStream *stream;
  unsigned int i;
  CslOptions options = { 0, };

  csl_parse_options (&options, &argc, &argv);
  csl_set_debug_mask (options.debug_flags);

  error = csl_driver_init (NULL, &driver);	/* choose backend */
  if (error)
    csl_error ("unable to initialize driver: %s", csl_strerror (error));

  error = csl_pcm_open_output (driver, "cslcat",
			       options.rate,
			       options.n_channels,
			       options.pcm_format,
			       &stream);
  if (error)
    csl_error ("failed to open output device: %s", csl_strerror (error));
  else if (csl_debug (PCM))
    {
      char *format1 = csl_describe_pcm_format (options.pcm_format);
      char *format2 = csl_describe_pcm_format (csl_pcm_get_format (stream));

      csl_message ("requested: (%s), got (%s)",
		   format1, format2);
      csl_free (format1);
      csl_free (format2);
    }

#if 0
  error = csl_pcm_set_packet_mode (stream, 32, 1024);
  if (error)
    csl_error ("unable to setup output device buffering: %s", csl_strerror (error));
  error = csl_pcm_activate (stream);
  if (error)
    csl_error ("unable to access output device: %s", csl_strerror (error));
#endif
  
  for (i = CLAMP (argc - 1, 0, 1); i < argc; i++)
    {
      unsigned int length;
      FILE *file = (i == 0 || (argv[i][0] == '-' && !argv[i][1])) ? stdin : fopen (argv[i], "r");

      if (file)
	{
	  unsigned char buffer[1024];
	  unsigned int l = 0;
	  
	  length = fread (buffer, 1, sizeof (buffer), file);
	  while (length > 0)
	    {
	      csl_pcm_write (stream, length, buffer);
	      l += length;
	      length = fread (buffer, 1, sizeof (buffer), file);
	    }
	  /*printf("done(%s): %d %d %d\n", argv[i],length,errno,l);*/
	  if (file != stdin)
	    fclose (file);
	}
      else if (argv[i][0] == '-' && argv[i][1] == 'h')
	{
	  char *blurb;

	  fprintf (stderr, "Usage: %s [options...] [files...]\n", argv[0]);
	  fprintf (stderr, "Options:\n");
	  blurb = csl_describe_options (2);
	  fprintf (stderr, "%s\n", blurb);
	  csl_free (blurb);
	}
      else
	fprintf (stderr, "%s: %s: %s\n", argv[0], argv[i], strerror (errno));
    }

  csl_pcm_close (stream);
  
  csl_driver_shutdown (driver);
  
  return 0;
}

/* this is how to _not_ do it: */

#if 0 /* preserve this eleete code portion for future usage (FIXME: need universe.h implementation patch) */
#include	<universe.h>
int
main (int argc, char *argv[])
{
  if (0)	/* DON'T enable this! */
    collapse ();
  return 0;
}
#endif
