/* Linear3D.h */

#import "Transformation3D.h"

#define L3D_X_AXIS 0
#define L3D_Y_AXIS 1
#define L3D_Z_AXIS 2

	/*
		these are constants to be used when calling rotate to choose an
		axis. 
	*/
		
@interface Linear3D:Transformation3D
{
	float coeff[4][3];
}
	/*
		coeff is the coefficients of the transformation matrix
		and the translation.
	*/

+new;

	/* initializes coeff such that the transformation is the identity */


- operateOn:(vector3D *)theVect;

	/* 
		will perform matrix multiplication with the vector3D pointed to by
		theVect, using the first three rows of the array coeff as a 3D 
		matrix, and adding the fourth as a translation vector.
		It will leave the result in the vector3D pointed to by theVect.
	*/
	
- operateOn:(vector3D *)theVects howMany:(int)count;

	/* 
		will perform the same operation as operateOn: to the array of vector3D
		pointed to by theVects. It will leave the array itself modified.
	*/

- concatBefore:aLinear;
- concatAfter:aLinear;

	/* 
		These methods combine the receiver with another Linear3D transformation
		in such a way the the receiver will be modified to perform both
		operations in succession, by doing simple matrix multiplication. 
		concatBefore: will make the receiver a 
		Linear3D such that it performs the receiver's original operation first,
		and aLinear's second. concatAfter: causes the receiver to perform it's
		original operation after aLinear's.
	*/

- rotation:(int)axis:(float)angle;

	/* 
		causes the values in coeff to be set such that it represents a rotation
		transformation of angle degrees, around the axis determined by axis
		using the constants L3D_X_AXIS,L3D_Y_AXIS and L3D_Z_AXIS.
	*/
		

- scaling:(float)x:(float)y:(float)z;

	/* 
		causes the values in coeff to be set such that it represents a scaling
		transformation,where x,y,z represent the scaling in each direction.
	*/

- translation:(float)x:(float)y:(float)z;

	/* 
		causes the values in coeff to be set such that it represents a
		translation transformation.
	*/

- (float)coefficient:(int)row column:(int)column;

	/* returns coeff[row][column] */
	
@end
