/* View3D.m */

#import "View3D.h"
#import "Transformation3D.h"
#import "Context3D.h"
#import <objc/List.h>

@implementation View3D

+ new 
{
	self = [super new];
	subviews=[List new];
	superview=nil;
	return self;
}
	
- moveto:(vector3D *)where 
{
	[transformation operateOn:where];
	[superview moveto:where];
	return self;
}

- lineto:(vector3D *)where 
{
	[transformation operateOn:where];
	[superview lineto:where];
	return self;
}

- polygon:(vector3D *)vertices howMany:(int)count 
{
	[transformation operateOn:vertices howMany:count];
	[superview polygon:vertices howMany:count];
	return self;
}
	
- superview 
{
	return superview;
}
	
- setSuperView:aView3D 
{
	superview=aView3D;
	return self;
}
	
- addSubView:aView3D 
{
	[aView3D setSuperView:self];
	[subviews addObjectIfAbsent:aView3D];
	return self;
}

- render 
{
	return self;
}
	
- display
{
	[self render];
	[subviews makeObjectsPerform:@selector(display)];
	return self;
}

- transformation 
{
	return transformation;
}
	
- setTransformation:anObject 
{
	transformation=anObject;
}
	
- subviews
{
	return subviews;
}

- free
{
	[transformation free];
	[subviews freeObjects];
	[subviews free];
	return [super free];
}

@end
