char copyright[]=
"xbmbrowser Version 4.0  (c) Copyright Ashley Roll and Anthony Thyssen.";
/*
*****************************************************************************
** FILE: xbmbrowser.c
**
** xbmbrowser is Public Domain. However it, and all the code still belong to me.
** I do, however grant permission for you to freely copy and distribute it on 
** the condition that this and all other copyright notices remain unchanged in 
** all distributions.
**
** This software comes with NO warranty whatsoever. I therefore take no
** responsibility for any damages, losses or problems that the program may 
** cause.
**                                     Anthony Thyssen and Ashley Roll
*****************************************************************************
*/

#define MAIN
#include "xbmbrowser.h"
#include "patchlevel.h"

/* application icon */
#include "icon.xbm"

/* Tick Box Symbols */
#include "tickbox_off.xbm"
#include "tickbox_on.xbm"

/* File Type Symbols */
#include "filesyms/unknown.xbm"
#include "filesyms/dir.xbm"
#include "filesyms/dirup.xbm"
#include "filesyms/dirlink.xbm"
#include "filesyms/dirbad.xbm"
#include "filesyms/file.xbm"
#include "filesyms/text.xbm"
#include "filesyms/binary.xbm"
#include "filesyms/xbm.xbm"  /* Xbm and xpm do not really need these symbols */
#include "filesyms/xpm.xbm"  /* but are included for completeness */
#include "filesyms/xpmbad.xbm"

/* -------------------------- */
static Atom  wm_delete_window;      /* insure that delete window works */

/* define command line options to change resource settings */
static XrmOptionDescRec cmdline_options[] = {
  /* option      resource      option_type      value */
  /* command line menu configuration file */
  {"-config",      "*cmd_rc",       XrmoptionSepArg,  NULL },
  {"-cf",          "*cmd_rc",       XrmoptionSepArg,  NULL },
  /* symbol resources */
  {"-iconsonly",   "*icons_only",   XrmoptionNoArg,  "True"},
  {"-dir",         "*show_dir",     XrmoptionNoArg,  "True"},
  {"-xpmbad",      "*show_xpmbad",  XrmoptionNoArg,  "True"},
  {"-other",       "*show_other",   XrmoptionNoArg,  "True"},
  /* symbol resources (inverted) */
  {"-noiconsonly", "*icons_only",   XrmoptionNoArg,  "False"},
  {"-nodir",       "*show_dir",     XrmoptionNoArg,  "False"},
  {"-noxpmbad",    "*show_xpmbad",  XrmoptionNoArg,  "False"},
  {"-noother",     "*show_other",   XrmoptionNoArg,  "False"},
  /* recursive directory scan */
  {"-R",           "*recursive",    XrmoptionNoArg,  "True"},
  {"-recursive",   "*recursive",    XrmoptionNoArg,  "True"},
};

/* define the applications own resources */
static XtResource resources[] = {
  /* res_name    res_class    res_type
   *   var_size    var_ptr  
   *     var_type     default_value */
  /* configuration resources */
  { "cmd_rc",       "Config",   XtRString,
       sizeof(char *),  XtOffset(AppDataPtr, cmd_rc),
         XtRString,        (XtPointer) NULL },
  { "user_rc",      "Config",   XtRString,
       sizeof(char *),   XtOffset(AppDataPtr, user_rc),
         XtRString,        (XtPointer) USERS_RC },
  { "library_rc",   "Config",   XtRString,
       sizeof(char *),   XtOffset(AppDataPtr, library_rc),
         XtRString,        (XtPointer) LIBRARY_RC },
  /* symbol resources */
  { "icons_only",   "Show",     XtRBoolean,
       sizeof(Boolean), XtOffset(AppDataPtr, icons_only),
         XtRImmediate,     (XtPointer) False },
  { "show_dir",     "Show",     XtRBoolean,
       sizeof(Boolean), XtOffset(AppDataPtr, show_dir),
         XtRImmediate,     (XtPointer) True },
  { "show_xpmbad",  "Show",     XtRBoolean,
       sizeof(Boolean), XtOffset(AppDataPtr, show_xpmbad),
         XtRImmediate,     (XtPointer) True },
  { "show_other",   "Show",     XtRBoolean,
       sizeof(Boolean), XtOffset(AppDataPtr, show_other),
         XtRImmediate,     (XtPointer) False },
  /* recursive directory scan */
  { "recursive",   XtCBoolean,  XtRBoolean,
       sizeof(Boolean), XtOffset(AppDataPtr, recursive),
         XtRImmediate,     (XtPointer) False },
  /* colors for file symbols */
  { "sym_foreground",  XtCForeground,  XtRPixel,
       sizeof(Pixel), XtOffset(AppDataPtr, sym_fore),
         XtRString,     (XtPointer) XtDefaultForeground },
  { "sym_background",  XtCBackground,  XtRPixel,
       sizeof(Pixel), XtOffset(AppDataPtr, sym_back),
         XtRString,     (XtPointer) XtDefaultBackground },
};

/* declare action routines for translations */
static XtActionsRec  actions[] = {
/* action_name    routine */
  { "Dir_Return", dir_return },      /* directory dialog return */
  { "Set_Name",   set_name },        /* set info line for this file */
  { "Set_Label",  set_label },       /* set general default information */
  { "Pos_Dir",    pos_dir },         /* Set dir menu's location */
  { "Pop_Menu",   popup_user_menu }, /* popup user menu (or cd to subdir) */
  { "Quit",       quit_browser },    /* quit application */
};

/* translation table for label widgets for the bitmaps */
char Translations[] = 
  "<EnterWindow>:  Set_Name() \n\
   <LeaveWindow>:  Set_Label() \n\
   <BtnDown>:      Pop_Menu() ";

/* translation table for the dialogWidget (directory name) */
static char text_trans[] = 
  "<Key>Return:  Dir_Return() \n\
   Ctrl<Key>M:   Dir_Return() \n\
   <Btn3Down>:   Pos_Dir() MenuPopup(dirmenu) ";

/*  translation table for the list widget */
static char list_trans[] =
   "<Enter>:      Set() \n\
    <Leave>:      Unset() \n\
    <BtnMotion>:  Set() \n\
    <BtnUp>:      MenuPopdown(dirmenu) Notify() Unset()"; 

/*  translation table for the transient shell containing the list */
/* this translation makes the list popdown if the button is released 
   outside the window */
static char tshell_trans[] = 
       "<BtnUp>: MenuPopdown(dirmenu)";

/* fallback resources -- things required to function at all */
static char *fall_back[] = {
   "XbmBrowser.width:    450",
   "XbmBrowser.height:   600",
   "*optmenu*leftMargin: 24", 
   NULL
}; 

/* -------------------------- */

static void usage()
{
  fprintf(stderr, "%s%s%s%s%s%s%s%s%s",
    "Usage: xbmbrowser [options...] [directory]\n",
    "    Where ``directory'' is an directory of icons to display.\n",
    "    Options can be any standard X toolkit option or...\n",
    "       -config file     Use the given config file instead\n",
    "       -(no)iconsonly   (Don't) Display only the icon images\n",
    "       -(no)dir         (Don't) Display directories found\n",
    "       -(no)xpmbad      (Don't) Display Bad X Pixmap Loads\n",
    "       -(no)other       (Don't) Display other files\n",
    "       -R | -recursive  Recursive Scan of all sub-directories\n"
  );
  exit(1);
}


main(argc, argv)
  int argc;
  char **argv;
{
  XtAppContext appcon;    /* these item only really needed in here */
  Widget       toplevel;  /* the application widget -- only needed in here */

  /* Setup the toplevel window */
  { char title[80];

    (void) sprintf(title,"XbmBrowser Version %s",PATCHLEVEL);
    toplevel = XtVaAppInitialize(
              &appcon, "XbmBrowser",       /* app context, ClassName */
              cmdline_options,             /* app command line options */
              XtNumber(cmdline_options),
              &argc, argv,                 /* command line */
              fall_back,                   /* Fall back resources */
              XtNtitle, (XtArgVal)title,
              NULL);                       /* End Va resource list */

    XtVaGetApplicationResources(
              toplevel, &app_data, resources, XtNumber(resources),
              /* varargs of non-user-defined resources here */
              NULL );

    XtAppAddActions( appcon, actions, XtNumber(actions) );
  }

  /* If no icon is set by the user -- set a default one */
  { Pixmap icon;

    XtVaGetValues(toplevel, XtNiconPixmap, &icon, NULL);
    if ( icon == None ) {
      icon = XCreateBitmapFromData(
              XtDisplay(toplevel), RootWindowOfScreen(XtScreen(toplevel)),
              (char *)icon_bits, icon_width, icon_height);
      XtVaSetValues(toplevel, XtNiconPixmap, icon, NULL);
    }
  }

  /* locate the users home directory, and save this for future use */
  /* required to find rc files where to find user's rc file */
  { extern char *getenv();
    (void) strcpy(home_dir, getenv("HOME"));
    if( strcmp(home_dir,"/") != 0 )
      (void) strncat(home_dir, "/", MAXNAMLEN);
  }

  /* Initialize other substitution strings */
  dir_name[0]  = '\0';
  file_name[0] = '\0';
  base_name[0] = '\0';
  suffix[0]    = '\0';
  input[0]     = '\0';

  /* process any other options leftover -- presumably a directory to cd to */
  { Boolean opts_done = FALSE, errored = FALSE;

    while( argc >= 2 && argv[1][0] == '-' && !opts_done ) {
      if( strcmp(argv[1], "--") == 0 )
	opts_done = TRUE;         /* "--" end of options */
      else {
	fprintf(stderr, "Unknown Option: %s\n", argv[1]);
        
      }
      argv++; argc--;
    }
    if( errored ) usage();
    if( argc > 2 ) {
      fprintf(stderr, "Too many arguments found.\n");
      usage();
    }
    if(argc == 2) {      /* any other argument is a directory name */
      strcpy(dir_name, argv[1]);  /* don't chdir() yet! */
    }
  }

  /* Initialize user menus from the appropiate RC file */
  /* Do this before we chdir() into some other directory */
  { FILE *rc;
    char rcfile[MAXNAMLEN];

     menu_global = menu_bitmap = menu_pixmap =
        menu_directory = menu_other = NULL;

    /* if a config file is on command line use it */
    if( app_data.cmd_rc != NULL
        && (rc = fopen(app_data.cmd_rc, "r")) != (FILE *)NULL  ) {
      read_user_menus(toplevel, rc, app_data.cmd_rc);
      fclose(rc);
    }
    else if( app_data.cmd_rc != NULL ) {
      /* We failed to open a config file given on the command line! */
      fprintf(stderr, "xbmbrowser: Cound not open -config \"%s\"\n",
                    app_data.cmd_rc );
      exit(-1);
    }
    /* try to find the config file in users home */
    else if( app_data.user_rc != NULL &&
             ( sprintf(rcfile, "%s%s", home_dir, app_data.user_rc),
               (rc = fopen(rcfile, "r")) != (FILE *)NULL ) ) {
      read_user_menus(toplevel, rc, rcfile);
      fclose(rc);
    }
    /* try the library default config file */
    else if( app_data.library_rc != NULL
             && (rc = fopen(app_data.library_rc, "r")) != (FILE *)NULL  ) {
      read_user_menus(toplevel, rc, app_data.library_rc);
      fclose(rc);
    }
    else {  /* unable to find and load any config file! */
      fprintf(stderr,"xbmbrowser: Can not find a menu configuration file\n"); 
      exit(-1);
    }
  }

  /* CD and Initialize dir_name correctly
  ** DO NOT call change_dir() later as this withh reset
  ** resursive resource setting
  */
  if( dir_name[0] != '\0' && chdir(dir_name) != 0 ) {
    fprintf(stderr,"xbmbrowser: couldn't chdir to '%s'\n",argv[1]);
    exit(-1);
  }
  (void) getcwd(dir_name, MAXNAMLEN);
  if( strcmp(dir_name,"/") != 0 )
    (void) strncat(dir_name, "/", MAXNAMLEN);

  /* collect some extra information */
  display  = XtDisplay(toplevel);
  colormap = DefaultColormapOfScreen(XtScreen(toplevel));

  /* create the cursors */
  normalCursor = XCreateFontCursor(display, XC_left_ptr);
  waitCursor   = XCreateFontCursor(display, XC_watch);

  /* create tickbox bitmaps for options menu */
  tickoff = XCreateBitmapFromData(
              XtDisplay(toplevel), RootWindowOfScreen(XtScreen(toplevel)),
              (char *)tickbox_off_bits, tickbox_off_width, tickbox_off_height);
  tickon  = XCreateBitmapFromData(
              XtDisplay(toplevel), RootWindowOfScreen(XtScreen(toplevel)),
              (char *)tickbox_on_bits, tickbox_on_width, tickbox_on_height);

  /* load all the filetype symbols required */
#ifndef OLD_SYMLOAD
# define load_file(sym,file) \
    filesyms[sym] = XCreatePixmapFromBitmapData( \
              XtDisplay(toplevel), RootWindowOfScreen(XtScreen(toplevel)),\
              (char *)CAT(file,_bits), CAT(file,_width), CAT(file,_height), \
              app_data.sym_fore, app_data.sym_back, \
              DefaultDepthOfScreen(XtScreen(toplevel)) )
#else
# define load_file(sym,file) \
    filesyms[sym] = XCreateBitmapFromData( \
              XtDisplay(toplevel), RootWindowOfScreen(XtScreen(toplevel)),\
              (char *)CAT(file,_bits), CAT(file,_width), CAT(file,_height) )
#endif /* OLD_SYMLOAD */
  load_file(Unknown, unknown);
  load_file(Dir,     dir);
  load_file(DirUp,   dirup);
  load_file(DirLink, dirlink);
  load_file(DirBad,  dirbad);
  load_file(File,    file);
  load_file(Text,    text);
  load_file(Binary,  binary);
  load_file(Xbm,     xbm);
  load_file(Xpm,     xpm);
  load_file(XpmBad,  xpmbad);
#undef load_file

  /* create a paned widget to put everything into */
  mainpw  = XtVaCreateManagedWidget(
              "main", panedWidgetClass, toplevel,
              XtNcursor,(XtArgVal)normalCursor,  /* the default cursour */
              NULL);

  /* create buttons and options menu */
  { Widget form, button, option, optmenu, optitem;

    /* create form to hold the buttons */
    form = XtVaCreateManagedWidget(
              "buttons", formWidgetClass, mainpw,
              XtNshowGrip,   (XtArgVal)False,
              XtNskipAdjust, (XtArgVal)True,NULL);

    /* create the Buttons */
    button = XtVaCreateManagedWidget(
              "quit", commandWidgetClass, form,
              NULL);
    XtAddCallback(button, XtNcallback, quit_browser, NULL);
    option = XtVaCreateManagedWidget(
              "options", menuButtonWidgetClass, form,
              XtNfromHoriz,  (XtArgVal)button,
              XtNmenuName,   (XtArgVal)"optmenu",
              NULL);
    button = XtVaCreateManagedWidget(
              "rescan", commandWidgetClass, form,
              XtNfromHoriz,  (XtArgVal)option,
              NULL);
    XtAddCallback(button, XtNcallback, rescan, NULL);

    /* create the options menu */
    optmenu = XtVaCreatePopupShell(
              "optmenu", simpleMenuWidgetClass, option,
              NULL);
    optitem = XtVaCreateManagedWidget(
              "icons_only", smeBSBObjectClass, optmenu,
              XtNleftBitmap, app_data.icons_only ? tickon : tickoff, NULL);
    XtAddCallback(optitem, XtNcallback, toggle_option, &app_data.icons_only);
    optitem = XtVaCreateManagedWidget(
              "show_dir", smeBSBObjectClass, optmenu,
              XtNleftBitmap, app_data.show_dir ? tickon : tickoff, NULL);
    XtAddCallback(optitem, XtNcallback, toggle_option, &app_data.show_dir);
    optitem = XtVaCreateManagedWidget(
              "show_xpmbad", smeBSBObjectClass, optmenu,
              XtNleftBitmap, app_data.show_xpmbad ? tickon : tickoff, NULL);
    XtAddCallback(optitem, XtNcallback, toggle_option, &app_data.show_xpmbad);
    optitem = XtVaCreateManagedWidget(
              "show_other", smeBSBObjectClass, optmenu,
              XtNleftBitmap, app_data.show_other ? tickon : tickoff, NULL);
    XtAddCallback(optitem, XtNcallback, toggle_option, &app_data.show_other);
    optitem = XtVaCreateManagedWidget(
              "line", smeLineObjectClass, optmenu, NULL);
    /* this is globally known so change_dir() can reset it */
    recur_opt = XtVaCreateManagedWidget(
              "recursive", smeBSBObjectClass, optmenu,
              XtNleftBitmap, app_data.recursive ? tickon : tickoff, NULL);
    XtAddCallback(recur_opt, XtNcallback, toggle_option, &app_data.recursive);
  }

  /* dialogWidget -- show and change the current directory
  ** NOTE: the actual value for this widget set in change_dir() 
  */
  dirwidget = XtVaCreateManagedWidget(
              "directory", dialogWidgetClass, mainpw,
              XtNlabel,      (XtArgVal)"Current Directory",
              XtNvalue,      (XtArgVal)dir_name, /* current directory */
              XtNshowGrip,   (XtArgVal)False,
              XtNskipAdjust, (XtArgVal)True,
              NULL);
  XtOverrideTranslations(XtNameToWidget(dirwidget,"value"),
              XtParseTranslationTable(text_trans));

  /* create the dirMenu list widget in a popup shell. */
  dirmenu = XtVaCreatePopupShell(
              "dirmenu", transientShellWidgetClass, dirwidget,
              XtNoverrideRedirect, (XtArgVal)True,
              XtNallowShellResize, (XtArgVal)True,
              NULL);
  XtOverrideTranslations(dirmenu, XtParseTranslationTable(tshell_trans));

  dirlist = XtVaCreateManagedWidget(
              "dirlist",listWidgetClass,dirmenu,
              XtNforceColumns,    True,   /* set the defaults */
              XtNdefaultColumns,  1,      /* changed later */
              NULL);
  XtAddCallback(dirlist, XtNcallback, dir_menu, NULL);
  XtOverrideTranslations(dirlist, XtParseTranslationTable(list_trans));

  /* label widget to hold information about the current bitmap */
  strcpy( label_info, "Loading Bitmaps" );   /* initialize label_info */
  label = XtVaCreateManagedWidget("label",labelWidgetClass,mainpw,
              XtNlabel,      (XtArgVal)label_info,
              XtNshowGrip,   (XtArgVal)False,
              XtNskipAdjust, (XtArgVal)True,NULL);

  /* setup the box to hold all the bitmaps */
  { Widget  viewport;
    Pixmap  stipple;
    int     width, fore, back, depth;

    XtVaGetValues(toplevel,XtNwidth,&width,NULL);
 
    /* create a viewport widget to stick the bitmaps in */
    viewport = XtVaCreateManagedWidget(
              "viewport",viewportWidgetClass,mainpw,
              XtNwidth,(XtArgVal)width,
              XtNallowHoriz,(XtArgVal)False,
              XtNallowVert,(XtArgVal)True,
              XtNshowGrip,(XtArgVal)False,
              XtNskipAdjust,(XtArgVal)True,NULL);

    /* create the box widget to put all the bitmaps in */
    bitmaps = XtVaCreateManagedWidget(
              "bitmaps",      boxWidgetClass,  viewport,
              XtNwidth,       width,
              XtNorientation, (XtArgVal)XtorientVertical,
              XtNfromVert,    (XtArgVal)label,
              NULL);

    /* find and set the stipple background pattern */
    XtVaGetValues(bitmaps,
              XtNborderColor, &fore,
              XtNbackground,  &back,
              XtNdepth,       &depth, NULL);
    stipple = XmuCreateStippledPixmap(XtScreen(bitmaps), fore, back, depth);
    XtVaSetValues(bitmaps,
              XtNbackgroundPixmap, (XtArgVal)stipple, NULL);
  }

  /* WARNING :- Heavy Magic in progress, Xperts please note....
  **   We need to Register the appropiate Grab Information for the
  ** popup_user_menu action routine. This is only needed as we are
  ** NOT using a MenuButton widget, or the builtin MenuPopup() action
  ** routine to do the actual popup. It is done this way to allow the
  ** application to pick the appropriate menu to popup or do a chdir(),
  ** depending on the type of object the widget is currently
  ** representing.
  **                                 --- Anthony Thyssen   2 May 1994
  */
  XtRegisterGrabAction(popup_user_menu, True,
              ButtonPressMask | ButtonReleaseMask,
              GrabModeAsync, GrabModeAsync);

  /* scan for the bitmaps -- DON'T call change_dir() */
  scan_bitmaps();

  XtRealizeWidget(toplevel);

  /* Set the window to call quit() action if `deleted' */
  XtOverrideTranslations(toplevel,     
              XtParseTranslationTable("<Message>WM_PROTOCOLS:Quit()") );
  wm_delete_window = XInternAtom(display, "WM_DELETE_WINDOW", False);
  (void) XSetWMProtocols(display, XtWindow(toplevel), &wm_delete_window, 1);

  /* start the main event loop */
  XtAppMainLoop(appcon);
}
