.TH XBMBROWSER 1 "20 March 1994"
.SH NAME
xbmbrowser \- view and manage X bitmap and X pixmap files.
.SH SYNOPSIS
.B xbmbrowser
[ \-\fIoptions\fP\.\.\. ]
[ \fIdirectory\fP ]

.SH DESCRIPTION
.LP
.B xbmbrowser 
will show you all the bitmaps or pixmaps in the 
.I directory
if it is specified otherwise it will look in the current directory.
Note that if the program can not change directory to the 
.I directory
in the command line it will exit and print an error message.

Once started the User can change the directory being displayed by either
.RS
.IP \(bu
Editing the displayed current directory string on the main application
window.
.IP \(bu
Selecting a directory from a popup menu, by pressing a mouse button
over the displayed current directory string. This is the recommended
method when you are moving around a directory tree that you know very
well.
.IP \(bu
Clicking with the first (left\-most) mouse button on a directory file symbol.
.IP \(bu
Or even through one of the user configurable popup menu actions (See below).
This is usfull to define a specific directory that you wish to change to
regularly.
.RE

.LP
This latest version of 
.B xbmbrowser
will also display small symbols for all the other files and directories
present in the displayed directory. These symbols can be turned of if
desired either through command line options, resources, or interactivly
within the program.

You can perform a many different operations on bitmap (or pixmap) file
that is being displayed, or even any of the other files in the current
directory. These operations include, Rename, Copy, Delete, Edit and Set it
as the backgorund root window pattern.

These operations are initialized from a default library configuration file
"\fI/usr/lib/X11/xbmbrowser\.menu\fP", or from the users own version of
this file "\fI\.xbmbrowserrc\fP" in the user's home directory.

.ne 10
.SH OPTIONS

.B Xbmbrowser
will take all the normal \fIXtoolkit\fP options as well as the following
command line options. All but the \fB\-cf\fP option can also be turned
on and off as and when required from an "\fIOptions\fP" menu (middle
button along the top of the main application window) or its default set
via X resource.

.ne 2
.TP
\fB\-cf\fP "\fIfile\fP"
.TP
\fB\-config\fP "\fIfile\fP"
Load the menu configuration from the given \fIfile\fP instead of either
the users rc file or the library configuration file.

.ne 2
.TP
\fB\-(no)iconsonly\fP
Only display (or not) the actual icons (bitmaps and pixmaps) found in the
current directory.  In other words do not display and file symbols for
directories or other files found in the current directory. This option is
provided to allow the user to turn of the display of a large number of
file symbols that can appear at times, and return xbmbrowser back to the
`older' version style.

Resource: \fBXbmBrowser\.icons_only:\fP \fIFalse\fP

.ne 2
.TP
\fB\-(no)dir\fP
Display (or not) directory symbols for any sub\-directories found. The
"\.\." directory symbol will also be removed.

Resource: \fBXbmBrowser\.show_dir:\fP \fITrue\fP

.ne 2
.TP
\fB\-(no)xpmbad\fP
Display (or not) any pixmaps which failed to load properly. This Pixmaps
usally couldn't be displayed as they were unable to allocate enough colors
on the current display. To display these, try quiting some other
applications, removing any root background image you may have on your
display, or even delete or move other pixmaps in the current directory
elsewhere.

Resource: \fBXbmBrowser\.show_xpmbad:\fP \fITrue\fP

.ne 2
.TP
\fB\-(no)other\fP
Display (or not) the other files found in the current directory. As part
of the attempt to load these files as icons for display, \fBxbmbrowser\fP
has determined weather or not these files are either binary, plain text,
or some other special file type.  It will use an appropiate file symbol to
show the user its findings.  \fINOTE:\fP Picture Image formats such as gif
and jpeg will appear as binary files.

Resource: \fBXbmBrowser\.show_other:\fP \fIFalse\fP

.ne 2
.TP
\fB\-R\fP or \fB\-recursive\fP
This option can slow xbmbrowser enormously. When it is turned on,
initially by this command line option, or interactively through the
"\fIOptions\fP" menu, \fBxbmbrowser\fP will recursively scan and display
all the files in the directories under the current directory.  This
directory search can take a very very long and could result in system
limitations crashing the program.  As such this option will be
automatically turned off any time \fBxbmbrowser\fP successfully changes
the current directory.

Resource: \fBXbmBrowser\.recursive:\fP \fIFalse\fP

This option was provided at the request of Steve Kinzler to allow
\fBxbmbrowser\fP to scan the directory tree structure of his ``faces''
collection (See  SEE ALSO  below).


.ne 10
.SH USER CONFIGURABLE MENUS

This version of \fBxbmbrowser\fP has a user definable menu of commands
that can be executed for displayed bitmaps pixmaps and other files.  There
is a default library configuration file, usally located in
"\fI/usr/lib/X11/xbmbrowser.menu\fP" (check with your system programmers)
or you can have your own config file called "\fI\.xbmbrowserrc\fP" in your
home directory. I suggest that you copy the library file
"\fI/usr/lib/X11/xbmbrowser.menu.tut\fP", which is a heavily commented
version of the default library file, to your home directory as
"\fI\.xbmbrowserrc\fP" and then edit it to suit your needs.

Each line of this file consists of either :-
.RS
.TP
\fB#\fP \fIcomment line\fP
A \fIcomment line\fP which is completely ignored. Comments can appear
at the end of any (non-continued) line.

.ne 6
.TP
\fBmenu\fP "\fIglobal\fP"
.TP
\fBmenu\fP "\fIglobal\fP" "\fIGlobal Menu\fP"
Add any new menu elements (see below) to this menu. Only specific menus
are allowed and will be titled using the optional second argument.  The
menus, if defined, will be poped up when the appropriate mouse button is
pressed on a displayed icon ot file symbol.  If the menu is not defined
the program will `beep' the user.  The following are the menus which the
user may define:-
.RS
.TP 14
"\fIglobal\fP"
A menu of global actions which will popup whenever the first two mouse
buttons are pressed on any type of displayed icon or file symbol. (See
NOTE below)
.TP 
"\fIbitmap\fP"
Display this menu on any displayed X bitmap with the right most (menu)
mouse button.
.TP 
"\fIpixmap\fP"
As "bitmap", but for any X pixmap (or pixmap which failed to load).
.TP 
"\fIdirectory\fP"
Same again, but for directory symbols.
.TP 
"\fIother\fP"
Again, for any other file symbol (text, binary..).
.RE

.ne 5
.IP 
\fINOTE\fP: If button 1 (leftmost or select mouse button) is pressed
on a directory symbol, the browser will automaticaly decend into that
directory, instead of poping up the global menu.

.ne 6
.TP
\fBline\fP      \&
Just insert a line into the menu at this point.

.TP
\fBitem\fP "Delete"	confirm("Really delete %f?") \e 
.TP
			exec("rm '%f'")   rescan()   
Insert a item into the current menu which will execute the sequence
builtin functions (see below). As it is posible for a very long
sequences to be required for some menu items, the menu lines can be
continued onto the next line by `backslashing' (\e) the return character
at the end of the line.

Each function may or may-not require some quoted string arguments,
with the quote being either single or double, allowing the other
quote to be used freely with the argument.

Each argument can contain any number of macro substitutions which
consist of a \fB%\fP character followed by a single letter. A percent
character can be substituted with \fB%%\fP.
.RE

.ne 5
The following builtin functions can be called (in sequence) from a
menu item :-
.RS
.TP
\fBquit\fP()
Exit \fBxbmbrowser\fP. Need I say more?
.TP
\fBscan\fP()
Completely scan the current directory (Again). (See \fBrescan\fP() below)
.TP
\fBrescan\fP()
Do a fast rescan of the current directory. Note that X pixmaps which
failed to load will NOT be loaded by this command, to avoid slowing the
\fBrescan\fP() in a directory of unloadable X pixmaps. This occurance
is actually common on a directory of pixmaps which do not follow a
standard color table.
.IP
To attempt to load these Pixmaps use either a full \fBscan\fP(), touch the
failed pixmap when more colors are available, or convert that pixmap to a
common color table.  Alturnatively, display the pixmap in a secondary
image viewer (converting it if neessary).
.TP
\fBchdir\fP("\fIdir\fP")
Change directory to the given directory. If the directory change succeeds
xbmbrowser will automatically do a full \fBscan\fP() of the new directory.
If this fails, no \fBscan\fP() will be performed.
.TP
\fBexec\fP("\fIcommand\fP")
Execute the given bourne shell \fIcommand\fP. Any output by the command
executed will be to the standard output (or error) of xbmbrowser, usally
the users terminal.
.TP
\fBconfirm\fP("\fIprompt\fP")
Ask the user to confirm action before continuing the next function.
If the user presses ``cancal'' the current function sequence will be
aborted.
.TP
\fBinput\fP("\fIprompt\fP","\fIinitial\fP")
Ask the user for some input, giving the user the "\fIinitial\fP"
string to start with. The result entered by the user will be returned
in the substitution marco \fB%i\fP (see below). The ``cancal'' button
will abort the current function sequence.
.RE

.ne 5
The following are substition macros can be used within function
arguments :-
.RS 
.TP
.B %d
The current directory of the browser.
Note that a the directory seperator '/' have been pre-added to this
substition macro.
.TP
.B %f
The filename of the icon (or file) the user menu in on.
.TP
.B %b
The basename (suffix removed) of the current filename.
.TP
.B %s
The suffix of the current filename  EG: ".xbm"
.TP
.B %i
The users input of the last \fBinput\fP() function (see above).
.TP
.B %h
The Users Home directory (do NOT use ~ in an argument for this).
Note that a the directory seperator '/' have been pre-added to this
substition macro.
.TP
.B %%
Substitutes a percent character, just in case you really do need it.
.RE

.ne 10
.SH FILES
.TP
\fI~/.xbmbrowserrc\fP
User's own menu configuration file.
.TP
\fI/usr/lib/X11/xbmbrowser.menu\fP
Default library menu configuration file. 
.TP
\fI/usr/lib/X11/xbmbrowser.menu.tut\fP
Verbose menu configuration file (with extra examples).
.LP
Note: Some of these files may be installed in different
directories on your system.

.SH "SEE ALSO"
.TP
\fB``Anthony's Icon Library''\fP
This is a Huge library of bitmaps and pixmaps of `icon' size. The library
is sorted into sections based of size and intended usage of the icons.
All the pixmaps in the library follow a standard color table of 30 colors
so you can use and view as many pixmaps as you require. It is for the
coordination of this library that xbmbrowser was originally developed.

The coordinator is \fBAnthony Thyssen\fP, and the collection is
downloadable from \fIftp://ftp\.x\.org/contrib/icons/AIcons\fP (soon) or
directly accessable via WWW on 
\fIhttp://www\.cit\.gu\.edu\.au/~anthony/icons\fP.

.TP
\fB``Faces'' bitmap collection\fP
A collection of `face' bitmaps all 48 by 48 pixels in size.  This
collection is designed for use by mail and news readers, and as such is
sorted into: news groups, logos, and people sorted by email address.
The bitmaps is stored in a large directory structure making the recursive
scan feature a must for viewing this collection.

The coordinator is \fBSteve Kinser\fP \fIkinzler@cs\.indiana\.edu\fP and
the collection is downloadable from \fIftp://cs\.indiana\.edu/pub/faces\fP.

.ne 10
.SH AUTHOR
.TP
Original Programmer
\fBAshley Roll\fP -- ash@cit.gu.edu.au
.TP
Current Programmer
\fBAnthony Thyssen\fP -- anthony@cit.gu.edu.au

