/*************************************************************
 *  
 *          I R I S P L O T   ---------- contour.c
 *
 *    Copyright (C) 1989 Maorong Zou
 *
 *************************************************************/


#ifdef HAVE_F77

#include <stdio.h>
#include "plot.h"

extern FILE    *file1;
extern double  xmax,xmin,ymax,ymin,zmax,zmin;
extern double  real();
extern struct  value   *complex();
extern int     check_range();
extern FILE    *datafile;
char           *malloc();

/********************************************************/

make_contour(t_plot)
     struct a_graph *t_plot;
{
  FILE    *fp,*fopen();
  /*
   *  Variables that will be passed to the fortran routine
   *  'cntclc_'
   */
  float   *cont_data,*xout,*yout,a_value,xat11,yat11,xat33,yat33;
  float   dx[1],dy[1],fradj,xprd[1],yprd[1];
  int     *ibox,npts,maxpts,iwhich,found,izero;
  int     row,col,inter,icontr,con_found,ijatxy[1],nhold[256];
  int     i,j,k;
  /*
   * local vars
   */
  double  x,y,xdiff,ydiff, z_max, z_min;
  float   xx,yy,zz,ox,oy;
  float   zat1,zat2,zat3,zat4;
  struct  value az;


  zat1=zat2=zat3=zat4=0.0;

  cont_data = (float *)
    malloc((unsigned int)
	   ((t_plot->picture).contour.sample)
	   *((t_plot->picture).contour.sample1) * sizeof(float));
  ibox = (int *)
    malloc((unsigned int)
	   ((t_plot->picture).contour.sample)
	   *((t_plot->picture).contour.sample1) * sizeof(int));
	   
  row = (t_plot->picture).contour.sample ;
  col = (t_plot->picture).contour.sample1 ;

  /*
   *  The maximum number of output pts is restricted less than
   *     4*( row + col)
   *  which we think is resonable
   */
  maxpts = 4*((t_plot->picture).contour.sample +
	      (t_plot->picture).contour.sample1);
  xout = (float *)malloc((unsigned int)
			 (4*((t_plot->picture).contour.sample+
			     (t_plot->picture).contour.sample1 )) 
			 * sizeof(float));
  yout = (float *)malloc((unsigned int)
			 (4*((t_plot->picture).contour.sample+
			     (t_plot->picture).contour.sample1))
			 * sizeof(float));

  (t_plot->picture).contour.nconts =
    (int **) malloc( (unsigned int)
		    ((t_plot->picture).contour.n_cs ) *sizeof(int *));  
  for( i = 0; i < ((t_plot->picture).contour.n_cs ); i++)
    *( ((t_plot->picture).contour.nconts) + i) = (int *)NULL;
  
  ox = -12345.0;
  oy= -12345.0; 
  inter = 3;      
  fradj = 0.0; 
  xat11 = 10000000.0;
  xat33 = -10000000.0;
  yat11 = 10000000.0; 
  yat33 = -10000000.0;

  izero = 0; 
  z_min = 10000000.0;
  z_max = -10000000.0;
  dx[0] = 0.0; 
  dy[0] = 0.0;

  if((t_plot->is_data))
    {
      xat11 = 1234567.0;
      yat11 = 1234567.0;

      if(!(fp = fopen(t_plot->data_file,"r")))
	os_error("cannot reopen file",NO_CARET);

      for(i = 0; i < (t_plot->picture).contour.sample;i++)
	{
	  for(j = 0; j<(t_plot->picture).contour.sample1; j++)
	    {
	      (void)fscanf(fp,"%f %f %f",&xx,&yy,&zz);
	      /*
	       * if contour is required to plot 3D, calculate the
	       * coor for the 4 corners
	       */
	      if((t_plot->picture).contour.threed)
		{
		  if(i ==0 && j ==0)
		    zat1 = (float)zz;
		  else if(i == (t_plot->picture).contour.sample-1 && j ==0)
		    zat2 = (float)zz;
		  else if(i == (t_plot->picture).contour.sample-1 && 
		     j ==(t_plot->picture).contour.sample1-1)
		    zat3 = (float)zz;
		  else if(i ==0 && j ==(t_plot->picture).contour.sample1-1) 
		    zat4 = (float)zz;
		  check_range((double)xx,(double)yy,(double)zz);
		}
	      else
		check_range((double)xx,(double)yy,0.0);
	      /*
	       * figure out the data range
	       */
	      if(z_max < (double)zz) z_max = (double)zz;
	      if(z_min > (double)zz) z_min = (double)zz;	
	      if(xat11 > xx) xat11 = xx;
	      if(yat11 > yy) yat11 = yy;
	      if(xat33 < xx) xat33 = xx;
	      if(yat33 < yy) yat33 = yy;
	      cont_data[j*row+i] = (float) zz;
	      /*
	       *  wired way to determine the grid step size
	       */
	      if(!dy[0] && (oy != -12345.0) && (yy != oy)) 
		dy[0] = (float) (yy-oy);
	      if(!dy[0]) oy = yy;
	      if(!dx[0] && (ox != -12345.0) && (xx != ox))
		dx[0] = (float) (xx - ox);
	      if(!dx[0]) ox = xx;
	    }
	}
      (void) fclose(fp);
    }
  else
    {
      xat11 = (t_plot->picture).contour.xmin; 
      yat11 = (t_plot->picture).contour.ymin;
      xat33 = (t_plot->picture).contour.xmax;
      yat33 = (t_plot->picture).contour.ymax;
      xdiff = ((t_plot->picture).contour.xmax - 
	       (t_plot->picture).contour.xmin) /
		 ( ((t_plot->picture).contour.sample)- 1.0);
      ydiff = ((t_plot->picture).contour.ymax -
	       (t_plot->picture).contour.ymin) /
		 (((t_plot->picture).contour.sample1)- 1.0);
      dx[0] = (float)xdiff;
      dy[0] = (float)ydiff;
      for (i = 0; i < (t_plot->picture).contour.sample; i++)
	{
	  x = (t_plot->picture).contour.xmin + i*xdiff;
	  for(j = 0; j < (t_plot->picture).contour.sample1;j++) 
	    {
	      y = (t_plot->picture).contour.ymin + j*ydiff;
	      (void) complex(&( (t_plot->picture).contour.fx->dummy_value),
			     x, 0.0);
	      (void) complex(&( (t_plot->picture).contour.fx->dummy_value1),
			     y, 0.0);
	      evaluate_at( ((t_plot->picture).contour.fx)->at,&az);
	      zz = (float) real(&az);
	      xx = (float)x; yy = (float)y;
	      if((t_plot->picture).contour.threed)
		{
		  if(i ==0 && j ==0) zat1 = (float)zz;
		  else if(i == (t_plot->picture).contour.sample-1 && j ==0) 
		    zat2 = (float)zz;
		  else if(i == (t_plot->picture).contour.sample-1 && 
			  j ==(t_plot->picture).contour.sample1-1)
		    zat3 = (float)zz;
		  else if(i ==0 && j ==(t_plot->picture).contour.sample1-1)
		    zat4 = (float)zz;
		  check_range((double)xx,(double)yy,(double)zz);
		}
	      else
		check_range((double)xx,(double)yy,0.0);
	      if(z_max < (double)zz) z_max = (double)zz;
	      if(z_min > (double)zz) z_min = (double)zz;	      
	      cont_data[j*row+i] = (float) zz;
	    }
	}
    }
  (void)fprintf(datafile,"%f %f %f\n",xat11,yat11,zat1 );
  (void)fprintf(datafile,"%f %f %f\n",xat33,yat11,zat2 );
  (void)fprintf(datafile,"%f %f %f\n",xat33,yat33,zat3 );
  (void)fprintf(datafile,"%f %f %f\n",xat11,yat33,zat4 );
  
  /*
   * data set, now find the contours
   */
  xdiff = (z_max-z_min)/((t_plot->picture).contour.n_cs+1);
  for(i = 0; i < (t_plot->picture).contour.n_cs; i++)
    {
      /*
       * if contour value not set, give the default one
       */
      if(*((t_plot->picture).contour.c_vs+ i)== BADVALUE)
	*((t_plot->picture).contour.c_vs + i) = 
	  (float) (i+1) * (float)xdiff + (float)z_min; 
    }
  
  for(i = 0; i < (t_plot->picture).contour.n_cs; i++)
    {
      a_value = (float) (*((t_plot->picture).contour.c_vs + i));
      found = 1;    
      iwhich = 1;
      con_found = 0;
      while(found)
	{
	  /*
	   * This is the FORTRAN routine defined in fcontour.f
	   * Thanks prof. Overman of the Math dept, U of A and
	   * Dr. Indik for providing us with the "cntclc" routine.
	   */
	  cntclc_(&iwhich,&cont_data[0],&row,&col,&row,
		  &a_value,&izero,&izero,&maxpts,&inter,&xat11,
		  &yat11,&izero,&izero,&dx[0],&dy[0],&fradj,&izero,&izero,
		  &izero,&ibox[0],&xout[0],&yout[0],&npts,&icontr,
		  &ijatxy[0],&xprd[0],&yprd[0]);
	  found = icontr;
	  if(icontr && (icontr != -1))  /* conter found and itis not a pt */
	    {
	      nhold[con_found] = npts;
	      con_found++;
	      for(k = 0; k < npts; k++)
		{
		  if((t_plot->picture).contour.threed)
		    (void)fprintf(datafile,"%f %f %f\n",
				  xout[k],yout[k],a_value);
		  else
		    (void)fprintf(datafile,"%f %f %f\n",
				  xout[k],yout[k],0.00);
		}
	      (void)fflush(datafile);
	    }
	}
      /*
       * send the information to current graphic object
       */
      ((t_plot->picture).contour.nconts)[i] = 
	(int *)malloc((unsigned int)(con_found +1)*sizeof(int));  
      ((t_plot->picture).contour.nconts)[i][0] = con_found;
      for(j = 0; j < con_found;j++) 
	((t_plot->picture).contour.nconts)[i][j+1] = nhold[j];
    }
  (void)free( (char *)cont_data);
  (void)free( (char *)ibox);
  (void)free( (char *)xout);
  (void)free( (char *)yout);
}
/********************************************************/
#endif
