#ifndef GSGOPHEROBJ_H
#define GSGOPHEROBJ_H

#include "STRstring.h"

#define A_FILE      '0'      /* Types of objects */
#define A_DIRECTORY '1'
#define A_CSO       '2'
#define A_ERROR     '3'
#define A_MACHEX    '4'
#define A_PCHEX     '5'
#define A_INDEX     '7'
#define A_TELNET    '8'
#define A_UNIXBIN   '9'
#define A_SOUND     's'
#define A_EVENT     'e'
#define A_CALENDAR  'c'
#define A_HTML      'h'
#define A_TN3270    'T'
#define A_MIME      'M'
#define A_EOI	    '.'


/** Our Gopher Object Type **/

struct g_struct
{
     char    sFileType;     /* The type of object (A_FILE, A_CSO, etc)*/
     String  *Title;        /* User displayable title */
     String  *Selstr;       /* Selector string on host... */
     String  *Host;         /* Internet name of host                  */
     int     iPort;         /* Port number on host                    */
     int     iItemnum;      /* The number of the item in the directory*/
     int     weight;        /* The weight, expressed as a # from 0-1000 */
};



typedef struct g_struct GopherStruct;
typedef struct g_struct GopherObj;

#define GSgetType(a) ((a)->sFileType)
#define GSsetType(a,b) (a)->sFileType=(b)

#define GSgetTitle(a) ((STRget((a)->Title)))
#define GSsetTitle(a,b) ((STRset((a)->Title, b)))

#define GSgetPath(a) ((STRget((a)->Selstr)))
#define GSsetPath(a,b) ((STRset((a)->Selstr, b)))

#define GSgetHost(a) ((STRget((a)->Host)))
#define GSsetHost(a,b) ((STRset((a)->Host, b)))

#define GSgetPort(a) ((a)->iPort)
#define GSsetPort(a,b) (a)->iPort=(b)

#define GSgetNum(a) ((a)->iItemnum)
#define GSsetNum(a,b) ((a)->iItemnum=(b))

#define GSgetWeight(a)   ((a)->weight)
#define GSsetWeight(a,b) ((a)->weight=(b))

/*** Real live functions defined in GSgopherobj.c ***/

GopherObj *GSnew();
void GSdestroy();
void GSinit();
void GStoNet();
void GStoNetHTML();
int  GSfromNet();
int  GSconnect();
int  GSfromLink();
void GStoLink();
void GScpy();
#endif /*GSGOPHEROBJ_H*/
