#include "STRstring.h"
#include <string.h>
#include "Malloc.h"

/*
 * Make a new string, should reuse destroyed strings....
 */

String *
STRnew()
{
     String *temp;

     temp = (String *) malloc(sizeof(String));
     temp->data = NULL;

     STRinit(temp);

     return(temp);
}

/*
 * Destroy a string
 */

void
STRdestroy(st)
  String *st;
{
     if (st->data != NULL)
	  free(st->data);

     free(st);
}


/*
 * Clear out all the crud...
 */

void 
STRinit(st) 
  String *st;
{
     st->len  = 0;
     if (st->data != NULL)
	  free(st->data);
     st->data = NULL;
}

/*
 * Set a string value
 */

void
STRset(st, str)
  String *st;
  char   *str;
{
     register int len;

     if (str == NULL)
	  return;

     if (*str == '\0')
	  len = 1;
     else
	  len = strlen(str) + 1;

     /* Uninitialized data... */

     if (st->data == NULL) {
	  st->data = (char *) malloc(len);
	  strcpy(st->data, str);
	  st->len = len-1;
     }

     /** Something's already there... **/

     else {
	  if (STRlen(st) > len)
	       strcpy(st->data, str);
	  else {
	       char *temp;

	       temp = realloc(st->data, len);
	       /*** Should check for NULL ... ***/
	       st->data = temp;
	       strcpy(st->data, str);
	  }
     }
}

/*
 * Add a string to the end of the string that's there already
 */

String*
STRcat(st, cp)
  String *st;
  char *cp;
{
     int len;
     char *temp;

     if (cp == NULL)
	  return(NULL);
     
     if (STRlen(st) == 0) {
	  STRset(st, cp);
	  return(st);
     }

     len = strlen(cp) + STRlen(st) + 1;

     temp = (char *) malloc(len);
     strcpy(temp, STRget(st));
     strcat(temp, cp);

     STRset(temp);
     
     free(temp);
}


int
STRcmp(st1, st2)
  String *st1;
  String *st2;
{
     register char *cp1, *cp2;

     cp1 = STRget(st1);
     cp2 = STRget(st2);

     if (cp1 == NULL) 
	  return(- !0);
     else if (cp2 == NULL)
	  return( !0);
     else
	  return(strcmp(cp1, cp2));
}
     
