#import <appkit/Application.h>

@interface AppWithDoc:Application
{
    id      activateMenu;	/* activate menu */
    id      infoPanel;		/* the Info... panel */
    id      versionField;	/* version field in info panel */
    float   version;		/* The number to put there */
    id      docClass;		/* Class of Document to use */
    STR     extension;		/* file extension for documents */
}

/* Public methods */

+ initialize;
+ new;
+ newClass:newDoc extension:(STR)newExt version:(int)newVersion;

/* Services */

- readFromFile:(const char *)filename;
- write:obj toFile:(const char *)filename;

- locateWindow:window;

/* Shared info */

- (STR) extension;
- currentDocument;
- saveAsPanel;

/* Target/Action methods */

- info:sender;
- new:sender;
- open:sender;
- print:sender;
- terminate:sender;

/* Application delegate methods */

- appDidInit:sender;
- (int) appOpenFile:(const char *)path type:(const char *)type;
- (BOOL) appAcceptsAnotherFile:sender;

/* Listener/Speaker methods */

- (int) msgDirectory:(char * const *)fullPath ok:(int *)flag;
- (int) msgVersion:(char * const *)aString ok:(int *)flag;
- (int) msgFile:(char * const *)fullPath ok:(int *)flag;
- (int) msgPrint:(const char *)fullPath ok:(int *)flag;

/* Activate menu updating */

- addDocument:(const char *) name;
- removeDocument:(const char *) name;
- renameDocument:(const char *) oldName to:(const char *) newName;
- activateDocument:sender;

@end
