#import "Deck.h"
#import "Card.h"
#import "Document.h"
#import "AppWithDoc.h"
#import "Random.h"
#import<appkit/nextstd.h>

#define ITEM(S) printf("\n\t%s\n",#S)
#define PrintDeck(S) printf("    " #S ":  %d\n",[deck S])
#define PrintCard(D,C,M) printf("%c%19.19s",C%4 ?' ':'\n',[[D objectAt:C] M]);
#define ShowAll(D) for (i=0;i<[D count]; i++) PrintCard(D, i,faceString:0);\
	printf("\n\n")

static void showNum(id rng)
{
    int i;
    for (i=0;i<10;i++)
	printf(" %6.3f",[rng number]);
}
static void showInt(id rng)
{
    int i;
    float f;
    for (i=0;i<10;i++)
	    printf(" %5i",[rng whole]);
    printf("\n");
}
static void showUnit(id rng)
{
    int i;
    for (i=0;i<10;i++)
	printf(" %6.3f",[rng unit]);
    printf("\n");
}

testRand()
{
    id rand;

    rand = [Random new];    ITEM(New);    showNum(rand);
    ITEM(1d10);    [rand scaleFrom:0 to:10];    showInt(rand);
    showInt(rand);	showInt(rand);	showInt(rand);
/*    ITEM(Gauss);    [rand gauss];    showUnit(rand);    showNum(rand);
    ITEM(Exponential);    [rand exp];    showUnit(rand);    showNum(rand);
*/    printf("\n");
}
testDeck()
{
	Deck *deck;
	Card *card;
	int i;

	ITEM(Create);	
	deck = [[NXApp readFromFile:"Standard.deck"] setMarkerAt:52];
/*	ShowAll(deck);*/

	
	card = [deck giveCard];	[[deck takeCard:card] shuffle:NXApp];
		ShowAll(deck);
	card = [deck giveCard];	[[deck takeCard:card] shuffle:NXApp];
		ShowAll(deck);
#ifdef FOO
	ITEM(Parameters);	PrintDeck(count);	PrintDeck(marker);
	ITEM(Free);	
#endif
	[deck freeObjects];	ITEM(Done.);
}


main()
{
	NXApp = [AppWithDoc new];
	testRand();
}

