/*****************************************************************************/
/* FileQueue.h								     */
/* interface file of FileQueue class 					     */
/* January 1990  Carl F. Sutter						     */
/*****************************************************************************/

#import <objc/Object.h>
#import <appkit/ScrollView.h>

#define MAXSELECTABLE 1024
@interface FileQueue:Object
   {
   // outlets
   id		queuePanel;			// connect to queue panel
   id		queueScroll;			// connect to custom ScrollView
   id		queueMatrix;			// connect to sample TextFieldCell(s)
   
   // internal instance variables
   BOOL		bPaused;			// flag if pasued button is set 
   BOOL		bSendWhenReady;			// send a file when available 
   int		nNumRows;			// number of items in the queue 
   int		nSelectedRows[MAXSELECTABLE];	// array of selected item indexes 
   int		nNumSelected;			// number of selected items 
   id		target;				// target object to send items to 
   SEL 		action;				// method to recieve items 
   }

// factory methods
+ new;
+ new:(id )targ action:(SEL )act; 

// outlet initialization methods
- setQueuePanel:anObject;
- setQueueScroll:anObject;
- setQueueMatrix:anObject;

/* application and window delegate messages */
- windowWillResize:sender toSize:(NXSize *)frameSize;

// actions from the panel
- pause:sender;
- remove:sender;
- toTop:sender;
- toBottom:sender;

// methods that can be called from the controlling object
- show:sender;
- setTarget:(id)targ; 
- setAction:(SEL)aSelector; 
- (BOOL)addItem:(const char *)szFileName;
- (char *)retrieveNext;
- retrieveNextWhenReady;

// internal methods
- setup;
- (BOOL)countOneSelected:cell;
- sendNext;

@end
