//
// Test1
//
// This program tests the Random class by requesting
// various types of values and printing them in a
// nice format.
//
// Version 1.0, 1991 May 30
//
// Written by Gregor Purdy
// gregor@oit.itd.umich.edu
//
// See the README and COPYING files included for
// information and distribution and usage rights. 
//


#import <stdio.h>
#import "Random.h"


int main(int argc, char *argv[])
{
    Random *roller;			// Roller to use for this test
    int loop;				// General loop variable
    
    printf("\n\n<< Beginning DieRoller functionality test>>\n\n");
    
    roller = [[Random alloc] init];
    
    printf("Here are 100 random integers (0 to 32767):\n");
    printf("{\n");
    for (loop = 0 ; loop < 100 ; loop++)
    	printf("%5d, ", [roller rand]);
    printf("\n}\n\n");
    
    printf("Here are 100 rolls in the range 0 to 99:\n");
    printf("{\n");
    for (loop = 0 ; loop < 100 ; loop++)
    	printf("%2d, ", [roller randMax:99]);
    printf("\n}\n\n");
    
    printf("Here are 100 rolls in the range 5 to 30:\n");
    printf("{\n");
    for (loop = 0 ; loop < 100 ; loop++)
    	printf("%2d, ", [roller randMin:5 Max:30]);
    printf("\n}\n\n");
    
    printf("Here are 100 percentile rolls:\n");
    printf("{\n");
    for (loop = 0 ; loop < 100 ; loop++)
    	printf("%3.3f, ", [roller percent] * 100);
    printf("\n}\n\n");
    
    printf("Here are 100 rolls of a 20 sided die:\n");
    printf("{\n");
    for (loop = 0 ; loop < 100 ; loop++)
    	printf("%2d, ", [roller rollDie:20]);
    printf("\n}\n\n");
    
    printf("Here are 100 rolls of 4 die 6:\n");
    printf("{\n");
    for (loop = 0 ; loop < 100 ; loop++)
    	printf("%2d, ", [roller roll:4 die:6]);
    printf("\n}\n\n");
    
    printf("Here are 100 rolls of the best 5 of 10 die 6:\n");
    printf("{\n");
    for (loop = 0 ; loop < 100 ; loop++)
    	printf("%2d, ", [roller rollBest:5 of:10 die:6]);
    printf("\n}\n\n");
    
    printf("<< This concludes the DieRoller functionality test>>\n\n");

    return 0;
}


//
// End of file.
//