#import "ScrollWindow.h"
#import <appkit/nextstd.h>
#import <appkit/ScrollView.h>

@implementation ScrollWindow

- becomeScrollWindow
{ id newContent;
	newContent = [ScrollView new];
	[newContent setAutosizing:(NX_WIDTHSIZABLE | NX_HEIGHTSIZABLE)];
	[newContent setDocView:[self setContentView:newContent]];
	return self;
}

- setMinFrameSize:(NXSize) newSize
{
	minFrameSize = newSize;
	return self;
}

- windowWillResize:sender toSize:(NXSize *)frameSize
{ NXRect contentRect, maxFrameRect;
	[[[self contentView] docView] getBounds:&contentRect];
	[ScrollWindow getFrameRect:&maxFrameRect forContentRect:&contentRect style:[self style]];
	frameSize->width = MIN(frameSize->width, maxFrameRect.size.width);
	frameSize->height = MIN(frameSize->height, maxFrameRect.size.height);
	frameSize->width = MAX(frameSize->width, minFrameSize.width);
	frameSize->height = MAX(frameSize->height, minFrameSize.height);
	return self;
}

- windowDidResize:sender
{ NXRect contentRect, maxFrameRect;
	[[[self contentView] docView] getBounds:&contentRect];
	[ScrollWindow getFrameRect:&maxFrameRect forContentRect:&contentRect style:[self style]];
	if ((frame.size.width < maxFrameRect.size.width) || (frame.size.height < maxFrameRect.size.height))
		[[[self contentView] setHorizScrollerRequired:YES] setVertScrollerRequired:YES];
	else
		[[[self contentView] setHorizScrollerRequired:NO] setVertScrollerRequired:NO];
	return self;
}

@end

