/*****************************************************************************/
/* ActivateMenu.m							     */
/* implementation file of ActivateMenu class of ViewGif2 application	     */
/* This IB Module handles most aspects of an Activate menu		     */
/* It also can display a panel to cycle through the menu like a slide show   */
/* This code is mostly borrowed from the Draw example App - Thanks, NeXT!    */
/* January 1990  Carl F. Sutter						     */
/*****************************************************************************/

#import "ActivateMenu.h"
#import <appkit/Application.h>		// for NXApp
#import <appkit/Matrix.h>
#import <appkit/MenuCell.h>
#import <appkit/ButtonCell.h>		// for title
#import <string.h>			// for strcpy, strcat

@implementation ActivateMenu

/*****************************************************************************/
/* new - initialize the activate menu					     */
/*****************************************************************************/
+ new
   {
   self = [super new];
   
   /* load nib file defining panel and outlets */
   [NXApp loadNibSection:"ActivateMenu.nib" owner:self];
   
   /* get the activate menu handle */
   if (![self findActivateMenu])
      {
      [self free];
      return( nil );
      }
   /* initialize the list of windows and timer */   
   winList = [List new];
   timer = nil;
   
   return( self );
   } /* new 1/31/90 CFS */


/*****************************************************************************/
/* findActivateMenu: - find the activate menu item from the main menu id     */
/*****************************************************************************/
- (BOOL)findActivateMenu
   {
   int		count;
   Matrix	*matrix;
   MenuCell	*menuCell;
   const char	*s;

   matrix = [[NXApp mainMenu] itemList];
   count = [matrix cellCount];
   while (count--)
      {
      menuCell = [matrix cellAt:count :0];
      s = [menuCell title];
      if (s && !strcmp(s, "Activate"))
         {
	 activateMenu = [menuCell target];
         return( YES );
	 }
      }
   return( NO );
   } /* findActivateMenu 1/31/90 CFS */
   
   
/*****************************************************************************/
/* outlet initialization methods   					     */
/*****************************************************************************/
- setSlideshowPanel:anObject  { slideshowPanel  = anObject;  return( self ); }
- setPeriod:anObject          { period          = anObject;  return( self ); }
  

/*****************************************************************************/
/* addDocument: - adds the window to the Activate menu			     */
/*****************************************************************************/
- addDocument:(Window *)winAdd
   {
   List		*cells;
   int		i;
   const char	*s;
   MenuCell	*menuCell;

   /* quit if no window was given */
   if (!winAdd) return( self );
   
   /* get the List of ButtonCells that make up the menu */
   cells = [[activateMenu itemList] cellList];
       
   /* add the new item to the menu */
   menuCell = [activateMenu addItem:[winAdd title]
                            action:@selector(activateDocument:) keyEquivalent:0];
   [menuCell setTarget:self];
   
   /* add the new window to the window list */
   [winList addObject:winAdd];
   
   /* resize the menu matrix to fit the cells and return */
   [activateMenu sizeToFit];
   return( self );
   } /* addDocument: 1/31/90 CFS */


/*****************************************************************************/
/* removeDocument: - removes the name from the Activate menu		     */
/*****************************************************************************/
- removeDocument:(Window *)winRemove
   {
   List		*cells;
   Matrix	*matrix;
   int		i, count;
   const char	*s;
   
   /* quit if no name was given */
   if (!winRemove) return( self );
   
   /* find and remove the named menu item */
   matrix = [activateMenu itemList];
   cells = [matrix cellList];
   count = [cells count];
   for (i=0; i<count; i++)
      {
      s = [[cells objectAt:i] title];
      if (s && !strcmp(s, [winRemove title]))
         {
	 [matrix removeRowAt:i andFree:YES];
	 //[winRemove close];
         [winList removeObjectAt:i];
	 break;
	 }
      }
       
   /* resize the menu matrix to fit the cells and return */
   [activateMenu sizeToFit];
   return( self );
   } /* removeDocument: 1/31/90 CFS */

 
/*****************************************************************************/
/* start_stop: - toggle the slide show  			   	     */
/*****************************************************************************/
- start_stop:sender
   {
   double	dPeriod;
   
   if (timer == nil)
      {
      nCurrentWindow = 0;
      dPeriod = [period doubleValue];
      [period setEnabled:NO];
      timer = [Animator newChronon:dPeriod adaptation:0.0 target:self
                        action:(SEL)"nextSlide:" autoStart:YES
	                eventMask:NX_ALLEVENTS];
      }
   else  /* stop the current slideshow */ 
      {
      [timer free];
      timer = nil;
      [period setEnabled:YES];
      }   		       
   return( self );
   } /* start_stop: 3/7/90 CFS */


/*****************************************************************************/
/* show: - display the slideshow panel					     */
/*****************************************************************************/
- show:sender
   {
   [slideshowPanel makeKeyAndOrderFront:self];
   return( self );
   } /* show: 3/7/90 CFS */


/*****************************************************************************/
/* activateDocument: - sent from menu, activate the appropriate window	     */
/*****************************************************************************/
- activateDocument:sender
   {
   [[winList objectAt:[sender selectedRow]] makeKeyAndOrderFront:self];
   return( self );
   } /* activateDocument 1/31/90 CFS */
   

/*****************************************************************************/
/* windowWillClose: - message from a doc window that it will close	     */
/*****************************************************************************/
- windowWillClose:(Window *)winRemove
   {
   [self removeDocument:winRemove];
   return( self );
   } /* windowWillClose: 1/31/90 CFS */
 
 
/*****************************************************************************/
/* nextSlide: - show the next document in the activate menu		     */
/*****************************************************************************/
- nextSlide:sender
   {
   nCurrentWindow++;
   if (nCurrentWindow > ([winList count] - 1)) nCurrentWindow = 0;
   [[winList objectAt:nCurrentWindow] makeKeyAndOrderFront:self];
   return( self );
   } /* nextSlide: 3/7/90 CFS */

  
@end
